
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="milligrams of vitamin C")
x1 = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="milligrams of vitamin B1")
x2 = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name="milligrams of vitamin B6")
x3 = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="milligrams of zinc")

# Define the objective function
m.setObjective(3 * x0 + 1 * x1 + 9 * x2 + 9 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * x0 + 1 * x1 + 8 * x2 + 7 * x3 >= 26)
m.addConstr(7 * x0 + 7 * x3 >= 38)
m.addConstr(7 * x0 + 1 * x1 + 8 * x2 + 7 * x3 >= 38)
m.addConstr(11 * x2 + 3 * x3 >= 22)
m.addConstr(8 * x0 + 6 * x1 >= 23)
m.addConstr(6 * x1 + 11 * x2 + 3 * x3 >= 21)
m.addConstr(8 * x0 + 6 * x1 + 3 * x3 >= 21)
m.addConstr(8 * x0 + 11 * x2 + 3 * x3 >= 21)
m.addConstr(6 * x1 + 11 * x2 + 3 * x3 >= 20)
m.addConstr(8 * x0 + 6 * x1 + 3 * x3 >= 20)
m.addConstr(8 * x0 + 11 * x2 + 3 * x3 >= 20)
m.addConstr(6 * x1 + 11 * x2 + 3 * x3 >= 12)
m.addConstr(8 * x0 + 6 * x1 + 3 * x3 >= 12)
m.addConstr(8 * x0 + 11 * x2 + 3 * x3 >= 12)
m.addConstr(8 * x0 + 6 * x1 + 11 * x2 + 3 * x3 >= 12)
m.addConstr(6 * x1 + 11 * x2 >= 18)
m.addConstr(8 * x0 + 11 * x2 >= 21)
m.addConstr(11 * x2 + 7 * x3 >= 33)
m.addConstr(8 * x0 + 6 * x1 + 11 * x2 + 7 * x3 >= 33)
m.addConstr(x0 - 8 * x1 >= 0)
m.addConstr(7 * x0 + 7 * x3 <= 61)
m.addConstr(7 * x0 + 8 * x2 <= 133)
m.addConstr(8 * x2 + 7 * x3 <= 89)
m.addConstr(8 * x0 + 3 * x3 <= 41)
m.addConstr(8 * x0 + 6 * x1 <= 39)
m.addConstr(6 * x1 + 11 * x2 <= 89)
m.addConstr(8 * x0 + 11 * x2 + 3 * x3 <= 24)
m.addConstr(6 * x1 + 11 * x2 + 7 * x3 <= 92)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin C: {x0.varValue}")
    print(f"Milligrams of vitamin B1: {x1.varValue}")
    print(f"Milligrams of vitamin B6: {x2.varValue}")
    print(f"Milligrams of zinc: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
