
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
steaks = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="steaks")
kale_salads = model.addVar(lb=0, vtype=GRB.INTEGER, name="kale_salads")

# Set objective function
model.setObjective(3 * steaks + 8 * kale_salads, GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * steaks + 2 * kale_salads >= 28, "protein_lower_bound")
model.addConstr(8 * steaks + 1 * kale_salads >= 20, "healthiness_lower_bound")
model.addConstr(-9 * steaks + 9 * kale_salads >= 0, "steaks_kale_relation")
model.addConstr(7 * steaks + 2 * kale_salads <= 58, "protein_upper_bound")
model.addConstr(8 * steaks + 1 * kale_salads <= 27, "healthiness_upper_bound")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective value:', model.objVal)
    print('Steaks:', steaks.x)
    print('Kale Salads:', kale_salads.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization terminated with status {model.status}")

