
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
steaks = m.addVar(vtype=GRB.CONTINUOUS, name="steaks")
kale_salads = m.addVar(vtype=GRB.INTEGER, name="kale_salads")

# Objective function: Minimize 3*steaks + 8*kale_salads
m.setObjective(3*steaks + 8*kale_salads, GRB.MINIMIZE)

# Constraints
# Total protein constraint: 7*steaks + 2*kale_salads >= 28
m.addConstr(7*steaks + 2*kale_salads >= 28, name="protein_min")

# Total healthiness rating constraint: 8*steaks + 1*kale_salads >= 20
m.addConstr(8*steaks + 1*kale_salads >= 20, name="healthiness_min")

# Specific constraint: -9*steaks + 9*kale_salads >= 0
m.addConstr(-9*steaks + 9*kale_salads >= 0, name="specific_constraint")

# Total protein should not exceed 58 grams: 7*steaks + 2*kale_salads <= 58
m.addConstr(7*steaks + 2*kale_salads <= 58, name="protein_max")

# Total healthiness rating should not exceed 27: 8*steaks + 1*kale_salads <= 27
m.addConstr(8*steaks + 1*kale_salads <= 27, name="healthiness_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Steaks: {steaks.x}")
    print(f"Kale Salads: {kale_salads.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
