
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    steaks = model.addVar(lb=0, name="steaks", vtype=gurobi.GRB.CONTINUOUS)
    kale_salads = model.addVar(lb=0, name="kale_salads", vtype=gurobi.GRB.INTEGER)

    # Objective function: minimize 3 * steaks + 8 * kale_salads
    model.setObjective(3 * steaks + 8 * kale_salads, gurobi.GRB.MINIMIZE)

    # Constraints
    # Total grams of protein >= 28
    model.addConstr(7 * steaks + 2 * kale_salads >= 28, name="protein_min")
    # Total healthiness rating >= 20
    model.addConstr(8 * steaks + 1 * kale_salads >= 20, name="healthiness_min")
    # -9 * steaks + 9 * kale_salads >= 0
    model.addConstr(-9 * steaks + 9 * kale_salads >= 0, name="steak_kale_balance")
    # Total grams of protein <= 58
    model.addConstr(7 * steaks + 2 * kale_salads <= 58, name="protein_max")
    # Total healthiness rating <= 27
    model.addConstr(8 * steaks + 1 * kale_salads <= 27, name="healthiness_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: steaks = {steaks.varValue}, kale_salads = {kale_salads.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible")
    else:
        print("The model has a non-optimal status")

solve_optimization_problem()
