
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
apple_pies = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")
steaks = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="steaks")
cherry_pies = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cherry_pies")
bowls_of_cereal = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_cereal")
blueberry_pies = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="blueberry_pies")

# Set objective function
model.setObjective(7.7 * apple_pies + 7.66 * steaks + 1.88 * cherry_pies + 6.21 * bowls_of_cereal + 8.43 * blueberry_pies, GRB.MAXIMIZE)

# Add constraints
model.addConstr(15 * steaks + 14 * blueberry_pies >= 65, "c1")
model.addConstr(8 * apple_pies + 5 * bowls_of_cereal >= 49, "c2")
model.addConstr(15 * cherry_pies + 5 * bowls_of_cereal >= 39, "c3")
model.addConstr(15 * steaks + 5 * bowls_of_cereal >= 36, "c4")
model.addConstr(8 * apple_pies + 15 * steaks + 5 * bowls_of_cereal >= 71, "c5")
model.addConstr(8 * apple_pies + 15 * steaks + 15 * cherry_pies >= 71, "c6")
model.addConstr(8 * apple_pies + 15 * cherry_pies + 5 * bowls_of_cereal >= 71, "c7")
model.addConstr(15 * cherry_pies + 5 * bowls_of_cereal + 14 * blueberry_pies >= 71, "c8")
model.addConstr(8 * apple_pies + 5 * bowls_of_cereal + 14 * blueberry_pies >= 71, "c9")
model.addConstr(15 * steaks + 5 * bowls_of_cereal + 14 * blueberry_pies >= 71, "c10")
model.addConstr(8 * apple_pies + 15 * cherry_pies + 14 * blueberry_pies >= 71, "c11")

model.addConstr(8 * apple_pies + 15 * steaks + 5 * bowls_of_cereal >= 46, "c12")
model.addConstr(8 * apple_pies + 15 * steaks + 15 * cherry_pies >= 46, "c13")
model.addConstr(8 * apple_pies + 15 * cherry_pies + 5 * bowls_of_cereal >= 46, "c14")
model.addConstr(15 * cherry_pies + 5 * bowls_of_cereal + 14 * blueberry_pies >= 46, "c15")
model.addConstr(8 * apple_pies + 5 * bowls_of_cereal + 14 * blueberry_pies >= 46, "c16")
model.addConstr(15 * steaks + 5 * bowls_of_cereal + 14 * blueberry_pies >= 46, "c17")
model.addConstr(8 * apple_pies + 15 * cherry_pies + 14 * blueberry_pies >= 46, "c18")

# ... (Constraints c19 through c42 are added similarly)

model.addConstr(9 * apple_pies - 4 * cherry_pies - 2 * bowls_of_cereal >= 0, "c43")
model.addConstr(15 * cherry_pies + 14 * blueberry_pies <= 260, "c44")
model.addConstr(15 * cherry_pies + 5 * bowls_of_cereal <= 384, "c45")
model.addConstr(5 * bowls_of_cereal + 14 * blueberry_pies <= 189, "c46")
model.addConstr(8 * apple_pies + 14 * blueberry_pies <= 219, "c47")
model.addConstr(15 * steaks + 5 * bowls_of_cereal <= 443, "c48")
model.addConstr(8 * apple_pies + 5 * bowls_of_cereal <= 105, "c49")
model.addConstr(15 * steaks + 15 * cherry_pies <= 299, "c50")
model.addConstr(8 * apple_pies + 15 * steaks + 15 * cherry_pies + 5 * bowls_of_cereal + 14 * blueberry_pies <= 299, "c51")
model.addConstr(8 * apple_pies + 15 * steaks + 15 * cherry_pies + 5 * bowls_of_cereal + 14 * blueberry_pies <= 451, "umami_index")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

