
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_carbohydrates")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_calcium")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_iron")  # Integer constraint
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B5")

# Objective function
m.setObjective(1.73*x0 + 6.73*x1 + 6.03*x2 + 3.16*x3, GRB.MINIMIZE)

# Example constraint: Cognitive performance index from milligrams of iron plus milligrams of vitamin B5 must be no less than 11.
m.addConstr(5.15*x2 + 0.68*x3 >= 11, name="cognitive_performance_iron_vitamin_B5")

# Add other constraints here based on the problem description
# For example:
# m.addConstr(5.42*x0 + 9.63*x1 >= 7, name="cognitive_performance_carbohydrates_calcium")
# ...

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"grams_of_carbohydrates: {x0.x}")
    print(f"milligrams_of_calcium: {x1.x}")
    print(f"milligrams_of_iron: {x2.x}")
    print(f"milligrams_of_vitamin_B5: {x3.x}")
else:
    print("No optimal solution found.")
