
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
paper_plates = model.addVar(vtype=GRB.INTEGER, name="x0")
ibuprofen = model.addVar(vtype=GRB.INTEGER, name="x1")
toilet_paper = model.addVar(vtype=GRB.INTEGER, name="x2")
diapers = model.addVar(vtype=GRB.INTEGER, name="x3")
milk = model.addVar(vtype=GRB.INTEGER, name="x4")

# Set objective function
model.setObjective(3.08*paper_plates**2 + 5.45*paper_plates*ibuprofen + 3.4*paper_plates*toilet_paper + 4.05*paper_plates*diapers + 5.91*paper_plates*milk + 2.46*ibuprofen**2 + 9.62*ibuprofen*toilet_paper + 8.76*ibuprofen*diapers + 2.2*toilet_paper**2 + 3.71*diapers**2 + 5.58*milk**2 + 5.18*paper_plates + 7.76*ibuprofen + 3.37*toilet_paper + 5.99*diapers + 8.27*milk, GRB.MINIMIZE)

# Add constraints
model.addConstr(2*toilet_paper**2 + 8*diapers**2 >= 26, "c0")
model.addConstr(2*paper_plates + 8*diapers >= 16, "c1")
model.addConstr(2*paper_plates + 6*milk >= 18, "c2")
model.addConstr(2*paper_plates + 11*toilet_paper >= 46, "c3")
model.addConstr(2*paper_plates + 3*ibuprofen + 11*toilet_paper + 8*diapers + 6*milk >= 46, "c4")
model.addConstr(10*paper_plates**2 + 5*milk**2 >= 27, "c5")
model.addConstr(10*paper_plates + 8*toilet_paper >= 40, "c6")
model.addConstr(6*ibuprofen**2 + 5*milk**2 >= 19, "c7")
model.addConstr(8*toilet_paper + 5*milk >= 40, "c8")
model.addConstr(6*ibuprofen + 9*diapers >= 42, "c9")
model.addConstr(10*paper_plates**2 + 8*toilet_paper**2 + 9*diapers**2 >= 37, "c10")
model.addConstr(10*paper_plates + 6*ibuprofen + 8*toilet_paper + 9*diapers + 5*milk >= 37, "c11")
model.addConstr(-3*ibuprofen**2 + 10*diapers**2 >= 0, "c12")
model.addConstr(3*ibuprofen**2 - 4*toilet_paper**2 >= 0, "c13")
model.addConstr(2*paper_plates**2 + 11*toilet_paper**2 + 6*milk**2 <= 118, "c14")
model.addConstr(11*toilet_paper**2 + 8*diapers**2 + 6*milk**2 <= 111, "c15")
model.addConstr(2*paper_plates**2 + 3*ibuprofen**2 + 6*milk**2 <= 194, "c16")
model.addConstr(3*ibuprofen**2 + 11*toilet_paper**2 + 8*diapers**2 <= 202, "c17")
model.addConstr(2*paper_plates**2 + 8*diapers**2 + 6*milk**2 <= 203, "c18")
model.addConstr(2*paper_plates + 3*ibuprofen + 11*toilet_paper <= 232, "c19")
model.addConstr(6*ibuprofen + 9*diapers <= 109, "c20")
model.addConstr(6*ibuprofen + 8*toilet_paper + 5*milk <= 119, "c21")
model.addConstr(10*paper_plates + 6*ibuprofen + 8*toilet_paper <= 209, "c22")
model.addConstr(10*paper_plates**2 + 8*toilet_paper**2 + 9*diapers**2 <= 153, "c23")
model.addConstr(8*toilet_paper + 9*diapers + 5*milk <= 156, "c24")
model.addConstr(10*paper_plates + 6*ibuprofen + 5*milk <= 160, "c25")
model.addConstr(10*paper_plates + 8*toilet_paper + 5*milk <= 182, "c26")
model.addConstr(6*ibuprofen + 9*diapers + 5*milk <= 204, "c27")


# Resource Constraints
model.addConstr(2*paper_plates + 3*ibuprofen + 11*toilet_paper + 8*diapers + 6*milk <= 245, "dollar_cost")
model.addConstr(10*paper_plates + 6*ibuprofen + 8*toilet_paper + 9*diapers + 5*milk <= 221, "weight")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

