
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="packs of paper plates", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="bottles of ibuprofen", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="toilet paper rolls", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="diapers", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="cartons of milk", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(3.08*x0**2 + 5.45*x0*x1 + 3.4*x0*x2 + 4.05*x0*x3 + 5.91*x0*x4 +
                       2.46*x1**2 + 9.62*x1*x2 + 8.76*x1*x3 + 2.2*x2**2 + 3.71*x3**2 +
                       5.58*x4**2 + 5.18*x0 + 7.76*x1 + 3.37*x2 + 5.99*x3 + 8.27*x4,
                       sense=gurobi.GRB.MINIMIZE)

    # Cost constraints
    model.addConstr(2*x0 <= 245)
    model.addConstr(3*x1 <= 245)
    model.addConstr(11*x2 <= 245)
    model.addConstr(8*x3 <= 245)
    model.addConstr(6*x4 <= 245)

    # Weight constraints
    model.addConstr(10*x0 <= 221)
    model.addConstr(6*x1 <= 221)
    model.addConstr(8*x2 <= 221)
    model.addConstr(9*x3 <= 221)
    model.addConstr(5*x4 <= 221)

    # Minimum spend constraints
    model.addConstr(11*x2**2 + 8*x3**2 >= 26)
    model.addConstr(2*x0 + 8*x3 >= 16)
    model.addConstr(2*x0 + 6*x4 >= 18)
    model.addConstr(2*x0 + 11*x2 >= 46)
    model.addConstr(2*x0 + 3*x1 + 11*x2 + 8*x3 + 6*x4 >= 46)

    # Weight limits and requirements
    model.addConstr(10*x0**2 + 5*x4**2 >= 27)
    model.addConstr(10*x0 + 8*x2 >= 40)
    model.addConstr(6*x1**2 + 5*x4**2 >= 19)
    model.addConstr(8*x2 + 5*x4 >= 40)
    model.addConstr(6*x1 + 9*x3 >= 42)
    model.addConstr(10*x0**2 + 8*x2**2 + 9*x3**2 >= 37)
    model.addConstr(10*x0 + 6*x1 + 8*x2 + 9*x3 + 5*x4 >= 37)

    # Additional constraints
    model.addConstr(-3*x1**2 + 10*x3**2 >= 0)
    model.addConstr(3*x1**2 - 4*x2**2 >= 0)
    model.addConstr(2*x0**2 + 11*x2**2 + 6*x4**2 <= 118)
    model.addConstr(11*x2**2 + 8*x3**2 + 6*x4**2 <= 111)
    model.addConstr(2*x0**2 + 3*x1**2 + 6*x4**2 <= 194)
    model.addConstr(3*x1**2 + 11*x2**2 + 8*x3**2 <= 202)
    model.addConstr(2*x0**2 + 8*x3**2 + 6*x4**2 <= 203)

    # Maximum spend and weight
    model.addConstr(2*x0 + 3*x1 + 11*x2 <= 232)
    model.addConstr(6*x1 + 9*x3 <= 109)
    model.addConstr(6*x1 + 8*x2 + 5*x4 <= 119)
    model.addConstr(10*x0 + 6*x1 + 8*x2 <= 209)
    model.addConstr(10*x0**2 + 8*x2**2 + 9*x3**2 <= 153)
    model.addConstr(8*x2 + 9*x3 + 5*x4 <= 156)
    model.addConstr(10*x0 + 6*x1 + 5*x4 <= 160)
    model.addConstr(10*x0 + 8*x2 + 5*x4 <= 182)
    model.addConstr(6*x1 + 9*x3 + 5*x4 <= 204)

    # Solve the model
    model.optimize()

    # Output the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("packs of paper plates: ", x0.varValue)
        print("bottles of ibuprofen: ", x1.varValue)
        print("toilet paper rolls: ", x2.varValue)
        print("diapers: ", x3.varValue)
        print("cartons of milk: ", x4.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
