
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
foods = ['black beans', 'cheeseburgers', 'protein bars', 'granola bars', 'cherry pies']
x = m.addVars(foods, lb=0.0, name=foods)

# Set objective function
m.setObjective(8 * x['black beans'] + 8 * x['cheeseburgers'] + 2 * x['protein bars'] + 5 * x['granola bars'] + 8 * x['cherry pies'], gp.GRB.MINIMIZE)

# Resource data
resources = {
    'r0': {'description': 'sourness index', 'upper_bound': 167, 'x0': 5.35, 'x1': 5.74, 'x2': 7.71, 'x3': 3.42, 'x4': 5.48},
    'r1': {'description': 'umami index', 'upper_bound': 253, 'x0': 7.76, 'x1': 1.55, 'x2': 5.65, 'x3': 7.87, 'x4': 7.39},
    'r2': {'description': 'milligrams of calcium', 'upper_bound': 294, 'x0': 7.87, 'x1': 6.7, 'x2': 1.63, 'x3': 7.07, 'x4': 7.97}
}

# Add resource constraints
for r_key, r_data in resources.items():
    m.addConstr(
        gp.quicksum(r_data[f'x{i}'] * x[foods[i]] for i in range(len(foods))) <= r_data['upper_bound'],
        name=r_data['description'] + "_upper_bound"
    )


# Add other constraints as specified in the prompt
m.addConstr(5.35 * x['black beans'] + 5.48 * x['cherry pies'] >= 12)
m.addConstr(5.74 * x['cheeseburgers'] + 7.71 * x['protein bars'] >= 25)
m.addConstr(5.35 * x['black beans'] + 5.74 * x['cheeseburgers'] >= 22)
m.addConstr(5.35 * x['black beans'] + 3.42 * x['granola bars'] >= 28)
m.addConstr(5.74 * x['cheeseburgers'] + 5.48 * x['cherry pies'] >= 27)
# ... (add all remaining constraints similarly)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print(f'Optimization ended with status {m.status}')

