
from gurobipy import Model, GRB

# Create a new model
model = Model("maximize_food")

# Create variables
cornichons = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cornichons")
bacon = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bacon")
pizza = model.addVar(lb=0, vtype=GRB.INTEGER, name="pizza")

# Set objective function
model.setObjective(7 * cornichons + 1 * bacon + 1 * pizza, GRB.MAXIMIZE)

# Add constraints
model.addConstr(7 * cornichons + 6 * bacon <= 22, "fiber_constraint1")
model.addConstr(7 * cornichons + 1 * pizza <= 22, "fiber_constraint2")
model.addConstr(7 * cornichons + 6 * bacon + 1 * pizza <= 23, "fiber_constraint3")
model.addConstr(7 * cornichons + 6 * bacon + 1 * pizza <= 23, "fiber_constraint4") # Redundant constraint


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Cornichons: {cornichons.x}")
    print(f"Bacon: {bacon.x}")
    print(f"Pizza: {pizza.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

