
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="cornichons")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="strips_of_bacon")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="slices_of_pizza")

# Define constraints
m.addConstr(7*x0 + 6*x1 <= 22, name="fiber_from_cornichons_and_bacon")
m.addConstr(7*x0 + x2 <= 22, name="fiber_from_cornichons_and_pizza")
m.addConstr(7*x0 + 6*x1 + x2 <= 23, name="total_fiber")

# Define the objective function
m.setObjective(7*x0 + x1 + x2, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"cornichons: {x0.x}")
    print(f"strips_of_bacon: {x1.x}")
    print(f"slices_of_pizza: {x2.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found")
