
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    cornichons = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="cornichons")
    strips_of_bacon = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="strips_of_bacon")
    slices_of_pizza = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="slices_of_pizza", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 7*cornichons + 2*strips_of_bacon + slices_of_pizza
    model.setObjective(7 * cornichons + 2 * strips_of_bacon + slices_of_pizza, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7 * cornichons + 6 * strips_of_bacon <= 22, name="fiber_from_cornichons_and_bacon")
    model.addConstr(7 * cornichons + slices_of_pizza <= 22, name="fiber_from_cornichons_and_pizza")
    model.addConstr(7 * cornichons + 6 * strips_of_bacon + slices_of_pizza <= 23, name="fiber_from_all_sources")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cornichons: {cornichons.varValue}")
        print(f"Strips of bacon: {strips_of_bacon.varValue}")
        print(f"Slices of pizza: {slices_of_pizza.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
