
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
hours_worked_by_John = m.addVar(name="hours_worked_by_John", lb=0)
hours_worked_by_Dale = m.addVar(name="hours_worked_by_Dale", lb=0)
hours_worked_by_Mary = m.addVar(name="hours_worked_by_Mary", lb=0)
hours_worked_by_Bobby = m.addVar(name="hours_worked_by_Bobby", lb=0)

# Define the objective function
m.setObjective(4 * hours_worked_by_John ** 2 + 9 * hours_worked_by_John * hours_worked_by_Dale + 
               8 * hours_worked_by_John * hours_worked_by_Mary + 9 * hours_worked_by_John * hours_worked_by_Bobby +
               2 * hours_worked_by_Dale ** 2 + 3 * hours_worked_by_Dale * hours_worked_by_Mary + 
               5 * hours_worked_by_Dale * hours_worked_by_Bobby + 4 * hours_worked_by_Mary ** 2 + 
               1 * hours_worked_by_Mary * hours_worked_by_Bobby + 6 * hours_worked_by_Bobby ** 2 +
               5 * hours_worked_by_John + 6 * hours_worked_by_Dale + 1 * hours_worked_by_Mary + 9 * hours_worked_by_Bobby,
               gp.GRB.MAXIMIZE)

# Define the constraints
# Individual attribute constraints
m.addConstr(hours_worked_by_John * 2 <= 78)
m.addConstr(hours_worked_by_John * 12 <= 110)
m.addConstr(hours_worked_by_John * 14 <= 99)
m.addConstr(hours_worked_by_Dale * 1 <= 78)
m.addConstr(hours_worked_by_Dale * 6 <= 110)
m.addConstr(hours_worked_by_Dale * 6 <= 99)
m.addConstr(hours_worked_by_Mary * 9 <= 78)
m.addConstr(hours_worked_by_Mary * 5 <= 110)
m.addConstr(hours_worked_by_Mary * 11 <= 99)
m.addConstr(hours_worked_by_Bobby * 12 <= 78)
m.addConstr(hours_worked_by_Bobby * 13 <= 110)
m.addConstr(hours_worked_by_Bobby * 11 <= 99)

# Combined attribute constraints
m.addConstr(hours_worked_by_John ** 2 * 2 + hours_worked_by_Dale ** 2 * 1 + hours_worked_by_Mary ** 2 * 9 >= 10)
m.addConstr(hours_worked_by_John * 2 + hours_worked_by_Dale * 1 + hours_worked_by_Bobby * 12 >= 10)
m.addConstr(hours_worked_by_Dale * 1 + hours_worked_by_Mary * 9 + hours_worked_by_Bobby * 12 >= 10)
m.addConstr(hours_worked_by_John * 2 + hours_worked_by_Dale * 1 + hours_worked_by_Mary * 9 >= 12)
m.addConstr(hours_worked_by_John * 2 + hours_worked_by_Dale * 1 + hours_worked_by_Bobby * 12 >= 12)
m.addConstr(hours_worked_by_Dale ** 2 * 1 + hours_worked_by_Mary ** 2 * 9 + hours_worked_by_Bobby ** 2 * 12 >= 12)
m.addConstr(hours_worked_by_John ** 2 * 2 + hours_worked_by_Dale ** 2 * 1 + hours_worked_by_Mary ** 2 * 9 >= 11)
m.addConstr(hours_worked_by_John ** 2 * 2 + hours_worked_by_Dale ** 2 * 1 + hours_worked_by_Bobby ** 2 * 12 >= 11)
m.addConstr(hours_worked_by_Dale * 1 + hours_worked_by_Mary * 9 + hours_worked_by_Bobby * 12 >= 11)

# Paperwork competence rating constraints
m.addConstr(hours_worked_by_John * 12 + hours_worked_by_Dale * 6 >= 14)
m.addConstr(hours_worked_by_John * 12 + hours_worked_by_Mary * 5 >= 15)
m.addConstr(hours_worked_by_Mary * 5 + hours_worked_by_Bobby * 13 >= 17)
m.addConstr(hours_worked_by_John * 12 + hours_worked_by_Bobby * 13 >= 15)
m.addConstr(hours_worked_by_Dale * 6 + hours_worked_by_Mary * 5 <= 47)
m.addConstr(hours_worked_by_John ** 2 * 12 + hours_worked_by_Dale ** 2 * 6 <= 27)
m.addConstr(hours_worked_by_Mary ** 2 * 5 + hours_worked_by_Bobby ** 2 * 13 <= 89)
m.addConstr(hours_worked_by_John ** 2 * 12 + hours_worked_by_Dale ** 2 * 6 + hours_worked_by_Mary ** 2 * 5 <= 52)
m.addConstr(hours_worked_by_Dale ** 2 * 6 + hours_worked_by_Mary ** 2 * 5 + hours_worked_by_Bobby ** 2 * 13 <= 62)
m.addConstr(hours_worked_by_John * 12 + hours_worked_by_Dale * 6 + hours_worked_by_Mary * 5 + hours_worked_by_Bobby * 13 <= 62)

# Organization score constraints
m.addConstr(hours_worked_by_John ** 2 * 14 + hours_worked_by_Dale ** 2 * 6 >= 11)
m.addConstr(hours_worked_by_Dale * 6 + hours_worked_by_Mary * 11 >= 9)
m.addConstr(hours_worked_by_Dale * 6 + hours_worked_by_Bobby * 11 >= 19)
m.addConstr(hours_worked_by_John ** 2 * 14 + hours_worked_by_Mary ** 2 * 11 >= 14)
m.addConstr(hours_worked_by_Mary * 11 + hours_worked_by_Bobby * 11 <= 96)
m.addConstr(hours_worked_by_Dale ** 2 * 6 + hours_worked_by_Bobby ** 2 * 11 <= 36)
m.addConstr(hours_worked_by_John * 14 + hours_worked_by_Mary * 11 <= 93)
m.addConstr(hours_worked_by_Dale ** 2 * 6 + hours_worked_by_Mary ** 2 * 11 <= 29)
m.addConstr(hours_worked_by_John * 14 + hours_worked_by_Dale * 6 + hours_worked_by_Mary * 11 + hours_worked_by_Bobby * 11 <= 29)

# Other constraints
m.addConstr(2 * hours_worked_by_John - 2 * hours_worked_by_Mary - 8 * hours_worked_by_Bobby >= 0)
m.addConstr(hours_worked_by_Dale * 1 + hours_worked_by_Bobby * 12 <= 35)
m.addConstr(hours_worked_by_John ** 2 * 2 + hours_worked_by_Mary ** 2 * 9 <= 56)
m.addConstr(hours_worked_by_John ** 2 * 2 + hours_worked_by_Bobby ** 2 * 12 <= 45)
m.addConstr(hours_worked_by_Dale * 1 + hours_worked_by_Mary * 9 <= 62)
m.addConstr(hours_worked_by_Mary ** 2 * 9 + hours_worked_by_Bobby ** 2 * 12 <= 56)
m.addConstr(hours_worked_by_John * 2 + hours_worked_by_Dale * 1 <= 52)
m.addConstr(hours_worked_by_Dale ** 2 * 1 + hours_worked_by_Mary ** 2 * 9 + hours_worked_by_Bobby ** 2 * 12 <= 54)
m.addConstr(hours_worked_by_John * 2 + hours_worked_by_Dale * 1 + hours_worked_by_Mary * 9 <= 30)
m.addConstr(hours_worked_by_John * 2 + hours_worked_by_Dale * 1 + hours_worked_by_Bobby * 12 <= 55)
m.addConstr(hours_worked_by_John * 2 + hours_worked_by_Dale * 1 + hours_worked_by_Mary * 9 + hours_worked_by_Bobby * 12 <= 55)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by John: {hours_worked_by_John.varValue}")
    print(f"Hours worked by Dale: {hours_worked_by_Dale.varValue}")
    print(f"Hours worked by Mary: {hours_worked_by_Mary.varValue}")
    print(f"Hours worked by Bobby: {hours_worked_by_Bobby.varValue}")
else:
    print("No optimal solution found.")
