
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
fat = m.addVar(vtype=gp.GRB.INTEGER, name="fat")
vit_e = m.addVar(vtype=gp.GRB.INTEGER, name="vit_e")
vit_b1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vit_b1")
vit_a = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vit_a")
vit_c = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vit_c")

# Set objective function
obj = 1.83*fat*fat + 8.56*fat*vit_e + 7.73*fat*vit_b1 + 3.94*fat*vit_a + 7.98*fat*vit_c + 4.15*vit_e*vit_e + 1.78*vit_e*vit_b1 + 2.28*vit_e*vit_a + 7.57*vit_e*vit_c + 3.2*vit_b1*vit_b1 + 4.42*vit_b1*vit_a + 7.06*vit_b1*vit_c + 4.1*vit_a*vit_a + 8.39*vit_a*vit_c + 6.68*vit_c*vit_c + 6.82*fat + 8.6*vit_e + 3.58*vit_b1 + 6.45*vit_a + 2.31*vit_c
m.setObjective(obj, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*fat + 20*vit_e + 26*vit_b1 + 25*vit_a + 22*vit_c <= 391, "r0") # Cardiovascular support index
m.addConstr(11*fat + 20*vit_e + 7*vit_b1 + 29*vit_a + 11*vit_c <= 483, "r1") # Energy stability index

m.addConstr(26*vit_b1*vit_b1 + 22*vit_c*vit_c >= 29, "c1")
m.addConstr(4*fat*fat + 25*vit_a*vit_a >= 28, "c2")
m.addConstr(4*fat + 20*vit_e >= 51, "c3")
m.addConstr(4*fat*fat + 20*vit_e*vit_e + 25*vit_a*vit_a >= 39, "c4")
m.addConstr(20*vit_e + 26*vit_b1 + 25*vit_a >= 39, "c5")
m.addConstr(4*fat + 20*vit_e + 26*vit_b1 >= 39, "c6")
m.addConstr(20*vit_e + 26*vit_b1 + 22*vit_c >= 39, "c7")
m.addConstr(4*fat*fat + 20*vit_e*vit_e + 25*vit_a*vit_a >= 76, "c8")
m.addConstr(20*vit_e + 26*vit_b1 + 25*vit_a >= 76, "c9")
m.addConstr(4*fat + 20*vit_e + 26*vit_b1 >= 76, "c10")
m.addConstr(20*vit_e + 26*vit_b1 + 22*vit_c >= 76, "c11")
m.addConstr(4*fat + 20*vit_e + 25*vit_a >= 53, "c12")
m.addConstr(20*vit_e + 26*vit_b1 + 25*vit_a >= 53, "c13")
m.addConstr(4*fat + 20*vit_e + 26*vit_b1 >= 53, "c14")
m.addConstr(20*vit_e + 26*vit_b1 + 22*vit_c >= 53, "c15")
m.addConstr(4*fat + 20*vit_e + 25*vit_a >= 47, "c16")
m.addConstr(20*vit_e + 26*vit_b1 + 25*vit_a >= 47, "c17")
m.addConstr(4*fat*fat + 20*vit_e*vit_e + 26*vit_b1*vit_b1 >= 47, "c18")
m.addConstr(20*vit_e + 26*vit_b1 + 22*vit_c >= 47, "c19")
m.addConstr(26*vit_b1*vit_b1 + 25*vit_a*vit_a <= 324, "c20")
m.addConstr(20*vit_e + 22*vit_c <= 162, "c21")
m.addConstr(4*fat + 20*vit_e <= 322, "c22")
m.addConstr(4*fat*fat + 26*vit_b1*vit_b1 <= 244, "c23")
m.addConstr(4*fat + 20*vit_e + 26*vit_b1 + 25*vit_a + 22*vit_c <= 244, "c24")
m.addConstr(29*vit_a + 11*vit_c <= 240, "c25")
m.addConstr(20*vit_e + 29*vit_a <= 122, "c26")
m.addConstr(11*fat + 20*vit_e + 7*vit_b1 + 29*vit_a + 11*vit_c <= 122, "c27")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

