
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="grams of fat", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="milligrams of vitamin E", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="milligrams of vitamin B1")
x3 = m.addVar(name="milligrams of vitamin A")
x4 = m.addVar(name="milligrams of vitamin C")

# Objective function
obj = 1.83*x0**2 + 8.56*x0*x1 + 7.73*x0*x2 + 3.94*x0*x3 + 7.98*x0*x4 + 4.15*x1**2 + 1.78*x1*x2 + 2.28*x1*x3 + 7.57*x1*x4 + 3.2*x2**2 + 4.42*x2*x3 + 7.06*x2*x4 + 4.1*x3**2 + 8.39*x3*x4 + 6.68*x4**2 + 6.82*x0 + 8.6*x1 + 3.58*x2 + 6.45*x3 + 2.31*x4

# Set the objective
m.setObjective(obj, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(4*x0 + 20*x1 + 26*x2 + 25*x3 + 22*x4 <= 391, name="cardiovascular_support_index")
m.addConstr(11*x0 + 20*x1 + 7*x2 + 29*x3 + 11*x4 <= 483, name="energy_stability_index")

m.addConstr(x2**2 + x4**2 >= 29, name="combined_cardiovascular_support_index_B1_C")
m.addConstr(x0**2 + x3**2 >= 28, name="combined_cardiovascular_support_index_fat_A")
m.addConstr(x0 + x1 >= 51, name="combined_cardiovascular_support_index_fat_E")
m.addConstr(x0**2 + x1**2 + x3**2 >= 39, name="combined_cardiovascular_support_index_fat_E_A")
m.addConstr(x1 + x2 + x3 >= 39, name="combined_cardiovascular_support_index_E_B1_A")
m.addConstr(x0 + x1 + x2 >= 39, name="combined_cardiovascular_support_index_fat_E_B1")
m.addConstr(x1 + x2 + x4 >= 39, name="combined_cardiovascular_support_index_E_B1_C")

m.addConstr(x0**2 + x1**2 + x3**2 >= 76, name="combined_cardiovascular_support_index_fat_E_A_76")
m.addConstr(x1 + x2 + x3 >= 76, name="combined_cardiovascular_support_index_E_B1_A_76")
m.addConstr(x0 + x1 + x2 >= 76, name="combined_cardiovascular_support_index_fat_E_B1_76")
m.addConstr(x1 + x2 + x4 >= 76, name="combined_cardiovascular_support_index_E_B1_C_76")

m.addConstr(x0 + x1 + x3 >= 53, name="combined_cardiovascular_support_index_fat_E_A_53")
m.addConstr(x1 + x2 + x3 >= 53, name="combined_cardiovascular_support_index_E_B1_A_53")
m.addConstr(x0 + x1 + x2 >= 53, name="combined_cardiovascular_support_index_fat_E_B1_53")
m.addConstr(x1 + x2 + x4 >= 53, name="combined_cardiovascular_support_index_E_B1_C_53")

m.addConstr(x0 + x1 + x3 >= 47, name="combined_cardiovascular_support_index_fat_E_A_47")
m.addConstr(x1 + x2 + x3 >= 47, name="combined_cardiovascular_support_index_E_B1_A_47")
m.addConstr(x0**2 + x1**2 + x2**2 >= 47, name="combined_cardiovascular_support_index_fat_E_B1_47")
m.addConstr(x1 + x2 + x4 >= 47, name="combined_cardiovascular_support_index_E_B1_C_47")

m.addConstr(x2**2 + x3**2 <= 324, name="combined_cardiovascular_support_index_B1_A")
m.addConstr(x1 + x4 <= 162, name="combined_cardiovascular_support_index_E_C")
m.addConstr(x0 + x1 <= 322, name="combined_cardiovascular_support_index_fat_E")
m.addConstr(x0**2 + x2**2 <= 244, name="combined_cardiovascular_support_index_fat_B1")
m.addConstr(x0 + x1 + x2 + x3 + x4 <= 244, name="combined_cardiovascular_support_index_all")
m.addConstr(x3 + x4 <= 240, name="combined_energy_stability_index_A_C")
m.addConstr(x1 + x3 <= 122, name="combined_energy_stability_index_E_A")
m.addConstr(11*x0 + 20*x1 + 7*x2 + 29*x3 + 11*x4 <= 122, name="combined_energy_stability_index_all")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Grams of fat: ", x0.varValue)
    print("Milligrams of vitamin E: ", x1.varValue)
    print("Milligrams of vitamin B1: ", x2.varValue)
    print("Milligrams of vitamin A: ", x3.varValue)
    print("Milligrams of vitamin C: ", x4.varValue)
else:
    print("The model is infeasible.")
