
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
    fat = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="fat")
    potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
    protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")

    # Set objective function
    m.setObjective(5 * vitamin_b7 + 2 * fat + 2 * potassium + 6 * protein, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13.69 * vitamin_b7 + 6.32 * fat >= 80, "c1")
    m.addConstr(6.32 * fat + 2.58 * protein >= 55, "c2")
    m.addConstr(6.32 * fat + 12.48 * potassium >= 54, "c3")
    m.addConstr(13.69 * vitamin_b7 + 6.32 * fat + 12.48 * potassium >= 69, "c4")
    m.addConstr(13.69 * vitamin_b7 + 12.48 * potassium + 2.58 * protein >= 69, "c5")
    m.addConstr(6.32 * fat + 12.48 * potassium + 2.58 * protein >= 69, "c6")
    m.addConstr(13.69 * vitamin_b7 + 6.32 * fat + 12.48 * potassium >= 67, "c7")
    m.addConstr(13.69 * vitamin_b7 + 12.48 * potassium + 2.58 * protein >= 67, "c8")
    m.addConstr(6.32 * fat + 12.48 * potassium + 2.58 * protein >= 67, "c9")
    m.addConstr(13.69 * vitamin_b7 + 6.32 * fat + 12.48 * potassium >= 70, "c10")
    m.addConstr(13.69 * vitamin_b7 + 12.48 * potassium + 2.58 * protein >= 70, "c11")
    m.addConstr(6.32 * fat + 12.48 * potassium + 2.58 * protein >= 70, "c12")
    m.addConstr(20.29 * vitamin_b7 + 13.15 * potassium >= 60, "c13")
    m.addConstr(20.29 * vitamin_b7 + 19.67 * fat >= 43, "c14")
    m.addConstr(13.15 * potassium + 24.51 * protein >= 103, "c15")
    m.addConstr(19.67 * fat + 24.51 * protein >= 78, "c16")
    m.addConstr(19.67 * fat + 13.15 * potassium + 24.51 * protein >= 109, "c17")
    m.addConstr(5 * vitamin_b7 - potassium + 8 * protein >= 0, "c18")
    m.addConstr(13.69 * vitamin_b7 + 2.58 * protein <= 226, "c19")
    m.addConstr(13.69 * vitamin_b7 + 6.32 * fat <= 270, "c20")
    m.addConstr(6.32 * fat + 2.58 * protein <= 104, "c21")
    m.addConstr(6.32 * fat + 12.48 * potassium <= 165, "c22")
    m.addConstr(13.69 * vitamin_b7 + 6.32 * fat + 12.48 * potassium + 2.58 * protein <= 165, "c23")
    m.addConstr(20.29 * vitamin_b7 + 13.15 * potassium <= 198, "c24")
    m.addConstr(19.67 * fat + 13.15 * potassium <= 222, "c25")
    m.addConstr(13.15 * potassium + 24.51 * protein <= 120, "c26")
    m.addConstr(20.29 * vitamin_b7 + 19.67 * fat <= 317, "c27")
    m.addConstr(20.29 * vitamin_b7 + 19.67 * fat + 13.15 * potassium + 24.51 * protein <= 317, "c28")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_b7:', vitamin_b7.x)
        print('fat:', fat.x)
        print('potassium:', potassium.x)
        print('protein:', protein.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
