
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cherry_pies = m.addVar(lb=0, name="cherry_pies")
tomatoes = m.addVar(lb=0, name="tomatoes")
ravioli = m.addVar(lb=0, name="ravioli")
rotisserie_chickens = m.addVar(lb=0, name="rotisserie_chickens")

# Set objective function
m.setObjective(6.18 * cherry_pies + 1.21 * tomatoes + 2.81 * ravioli + 6.74 * rotisserie_chickens, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * cherry_pies + 2 * tomatoes + 8 * ravioli + 2 * rotisserie_chickens <= 82, "dollar_cost") # Resource constraint r0
m.addConstr(8 * cherry_pies + 8 * tomatoes + 2 * ravioli + 2 * rotisserie_chickens <= 60, "carbohydrates") # Resource constraint r1

m.addConstr(2 * tomatoes + 2 * rotisserie_chickens >= 7, "min_tomatoes_rotisserie_cost")
m.addConstr(5 * cherry_pies + 2 * rotisserie_chickens >= 10, "min_cherry_pies_rotisserie_cost")
m.addConstr(5 * cherry_pies + 8 * ravioli >= 18, "min_cherry_pies_ravioli_cost")
m.addConstr(5 * cherry_pies + 2 * tomatoes >= 6, "min_cherry_pies_tomatoes_cost")

m.addConstr(8 * cherry_pies + 2 * ravioli + 2 * rotisserie_chickens >= 10, "min_carbs1")
m.addConstr(8 * cherry_pies + 8 * tomatoes + 2 * rotisserie_chickens >= 10, "min_carbs2")
m.addConstr(8 * tomatoes + 2 * ravioli + 2 * rotisserie_chickens >= 10, "min_carbs3")
m.addConstr(8 * cherry_pies + 2 * ravioli + 2 * rotisserie_chickens >= 15, "min_carbs4")
m.addConstr(8 * cherry_pies + 8 * tomatoes + 2 * rotisserie_chickens >= 15, "min_carbs5")
m.addConstr(8 * tomatoes + 2 * ravioli + 2 * rotisserie_chickens >= 15, "min_carbs6")
m.addConstr(8 * cherry_pies + 2 * ravioli + 2 * rotisserie_chickens >= 15, "min_carbs7")
m.addConstr(8 * cherry_pies + 8 * tomatoes + 2 * rotisserie_chickens >= 15, "min_carbs8")
m.addConstr(8 * tomatoes + 2 * ravioli + 2 * rotisserie_chickens >= 15, "min_carbs9")


m.addConstr(5 * cherry_pies + 2 * tomatoes <= 27, "max_cherry_pies_tomatoes_cost")
m.addConstr(5 * cherry_pies + 2 * rotisserie_chickens <= 51, "max_cherry_pies_rotisserie_cost")
m.addConstr(5 * cherry_pies + 8 * ravioli <= 42, "max_cherry_pies_ravioli_cost")
m.addConstr(5 * cherry_pies + 2 * tomatoes + 8 * ravioli + 2 * rotisserie_chickens <= 42, "max_total_cost")

m.addConstr(8 * cherry_pies + 2 * ravioli <= 34, "max_carbs1")
m.addConstr(2 * ravioli + 2 * rotisserie_chickens <= 56, "max_carbs2")
m.addConstr(8 * cherry_pies + 8 * tomatoes + 2 * ravioli + 2 * rotisserie_chickens <= 56, "max_carbs3")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

