
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables (these are continuous because the problem states that the quantities don't have to be integers)
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cherry_pies")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="tomatoes")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ravioli")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rotisserie_chickens")

# Objective function
m.setObjective(6.18*x0 + 1.21*x1 + 2.81*x2 + 6.74*x3, GRB.MAXIMIZE)

# Constraints
# Minimum spend constraints
m.addConstr(2*x1 + 2*x3 >= 7, name="min_spend_tomatoes_rotisserie")
m.addConstr(5*x0 + 2*x3 >= 10, name="min_spend_cherry_pies_rotisserie")
m.addConstr(5*x0 + 8*x2 >= 18, name="min_spend_cherry_pies_ravioli")
m.addConstr(5*x0 + 2*x1 >= 6, name="min_spend_cherry_pies_tomatoes")

# Carbohydrate content constraints
m.addConstr(8*x0 + 2*x2 + 2*x3 >= 10, name="carb_cherry_ravioli_rotisserie_min")
m.addConstr(8*x0 + 8*x1 + 2*x3 >= 10, name="carb_cherry_tomatoes_rotisserie_min")
m.addConstr(8*x1 + 2*x2 + 2*x3 >= 10, name="carb_tomatoes_ravioli_rotisserie_min")
m.addConstr(8*x0 + 2*x2 + 2*x3 >= 15, name="carb_cherry_ravioli_rotisserie_min_15")
m.addConstr(8*x0 + 8*x1 + 2*x3 >= 15, name="carb_cherry_tomatoes_rotisserie_min_15")
m.addConstr(8*x1 + 2*x2 + 2*x3 >= 15, name="carb_tomatoes_ravioli_rotisserie_min_15")

# Maximum spend constraints
m.addConstr(5*x0 + 2*x1 <= 27, name="max_spend_cherry_pies_tomatoes")
m.addConstr(5*x0 + 2*x3 <= 51, name="max_spend_cherry_pies_rotisserie")
m.addConstr(5*x0 + 8*x2 <= 42, name="max_spend_cherry_pies_ravioli")
m.addConstr(5*x0 + 2*x1 + 8*x2 + 2*x3 <= 42, name="max_total_spend")

# Maximum carbohydrate content constraints
m.addConstr(8*x0 + 2*x2 <= 34, name="max_carb_cherry_ravioli")
m.addConstr(2*x2 + 2*x3 <= 56, name="max_carb_ravioli_rotisserie")
m.addConstr(8*x0 + 8*x1 + 2*x2 + 2*x3 <= 56, name="max_total_carb")

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))
