
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
b5 = m.addVar(name="milligrams_of_vitamin_B5")
a = m.addVar(name="milligrams_of_vitamin_A")

# Set objective function
m.setObjective(5 * b5 + 7 * a, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(13 * b5 + 16 * a >= 10, "cognitive_performance_min")
m.addConstr(4 * b5 + 16 * a >= 27, "energy_stability_min")
m.addConstr(5 * b5 + 5 * a >= 14, "immune_support_min")
m.addConstr(13 * b5 + 8 * a >= 30, "digestive_support_min")
m.addConstr(2 * b5 + 3 * a >= 19, "muscle_growth_min")

m.addConstr(10 * b5 - 2 * a >= 0, "b5_a_ratio")

m.addConstr(13 * b5 + 16 * a <= 33, "cognitive_performance_max")
m.addConstr(4 * b5 + 16 * a <= 60, "energy_stability_max")
m.addConstr(5 * b5 + 5 * a <= 84, "immune_support_max")
m.addConstr(13 * b5 + 8 * a <= 87, "digestive_support_max")
m.addConstr(2 * b5 + 3 * a <= 53, "muscle_growth_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Milligrams of Vitamin B5: {b5.x}")
    print(f"Milligrams of Vitamin A: {a.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

