
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    vitamin_B5 = model.addVar(lb=0, name="vitamin_B5")  # milligrams of vitamin B5
    vitamin_A = model.addVar(lb=0, name="vitamin_A")  # milligrams of vitamin A

    # Objective function
    model.setObjective(5 * vitamin_B5 + 7 * vitamin_A, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Individual constraints (not actually needed as they are part of the combined constraints)
    # model.addConstr(vitamin_B5 == 13, name="cognitive_performance_B5")
    # ...

    # Combined constraints
    model.addConstr(13 * vitamin_B5 + 16 * vitamin_A >= 10, name="cognitive_performance_min")
    model.addConstr(13 * vitamin_B5 + 16 * vitamin_A <= 33, name="cognitive_performance_max")

    model.addConstr(4 * vitamin_B5 + 16 * vitamin_A >= 27, name="energy_stability_min")
    model.addConstr(4 * vitamin_B5 + 16 * vitamin_A <= 60, name="energy_stability_max")

    model.addConstr(5 * vitamin_B5 + 5 * vitamin_A >= 14, name="immune_support_min")
    model.addConstr(5 * vitamin_B5 + 5 * vitamin_A <= 84, name="immune_support_max")

    model.addConstr(13 * vitamin_B5 + 8 * vitamin_A >= 30, name="digestive_support_min")
    model.addConstr(13 * vitamin_B5 + 8 * vitamin_A <= 87, name="digestive_support_max")

    model.addConstr(2 * vitamin_B5 + 3 * vitamin_A >= 19, name="muscle_growth_min")
    model.addConstr(2 * vitamin_B5 + 3 * vitamin_A <= 53, name="muscle_growth_max")

    # Additional constraint
    model.addConstr(10 * vitamin_B5 - 2 * vitamin_A >= 0, name="additional_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Vitamin B5: {vitamin_B5.x}")
        print(f"Vitamin A: {vitamin_A.x}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
