
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
laura_hours = model.addVar(lb=0, name="laura_hours")
ringo_hours = model.addVar(lb=0, name="ringo_hours")
mary_hours = model.addVar(lb=0, name="mary_hours")
dale_hours = model.addVar(lb=0, name="dale_hours")

# Set objective function
model.setObjective(3 * laura_hours + 1 * ringo_hours + 3 * mary_hours + 6 * dale_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(9 * laura_hours + 22 * dale_hours >= 45, "c1")
model.addConstr(13 * ringo_hours + 31 * mary_hours >= 98, "c2")
model.addConstr(9 * laura_hours + 13 * ringo_hours + 22 * dale_hours >= 83, "c3")
model.addConstr(10 * laura_hours + 6 * mary_hours >= 43, "c4")
model.addConstr(6 * mary_hours + 18 * dale_hours >= 68, "c5")
model.addConstr(6 * laura_hours + 4 * dale_hours >= 24, "c6")
model.addConstr(6 * laura_hours + 8 * mary_hours >= 49, "c7")
model.addConstr(6 * laura_hours + 1 * ringo_hours + 4 * dale_hours >= 56, "c8")
model.addConstr(6 * laura_hours + 1 * ringo_hours + 8 * mary_hours >= 56, "c9")
model.addConstr(6 * laura_hours + 1 * ringo_hours + 4 * dale_hours >= 32, "c10")
model.addConstr(6 * laura_hours + 1 * ringo_hours + 8 * mary_hours >= 32, "c11")

model.addConstr(13 * ringo_hours + 31 * mary_hours <= 424, "c12")
model.addConstr(31 * mary_hours + 22 * dale_hours <= 336, "c13")
model.addConstr(9 * laura_hours + 22 * dale_hours <= 316, "c14")
model.addConstr(13 * ringo_hours + 22 * dale_hours <= 262, "c15")
model.addConstr(9 * laura_hours + 31 * mary_hours <= 390, "c16")
model.addConstr(13 * ringo_hours + 31 * mary_hours + 22 * dale_hours <= 289, "c17")
model.addConstr(9 * laura_hours + 13 * ringo_hours + 22 * dale_hours <= 126, "c18")
model.addConstr(9 * laura_hours + 13 * ringo_hours + 31 * mary_hours <= 211, "c19")
model.addConstr(9 * laura_hours + 13 * ringo_hours + 31 * mary_hours + 22 * dale_hours <= 211, "c20")

model.addConstr(10 * laura_hours + 6 * mary_hours <= 266, "c21")
model.addConstr(6 * mary_hours + 18 * dale_hours <= 166, "c22")
model.addConstr(5 * ringo_hours + 6 * mary_hours <= 170, "c23")
model.addConstr(10 * laura_hours + 18 * dale_hours <= 93, "c24")
model.addConstr(5 * ringo_hours + 18 * dale_hours <= 221, "c25")
model.addConstr(10 * laura_hours + 5 * ringo_hours + 6 * mary_hours + 18 * dale_hours <= 221, "c26")

model.addConstr(1 * ringo_hours + 8 * mary_hours <= 60, "c27")
model.addConstr(6 * laura_hours + 8 * mary_hours <= 71, "c28")
model.addConstr(1 * ringo_hours + 8 * mary_hours + 4 * dale_hours <= 63, "c29")
model.addConstr(6 * laura_hours + 1 * ringo_hours + 4 * dale_hours <= 182, "c30")
model.addConstr(6 * laura_hours + 8 * mary_hours + 4 * dale_hours <= 76, "c31")
model.addConstr(6 * laura_hours + 1 * ringo_hours + 8 * mary_hours + 4 * dale_hours <= 76, "c32")

model.addConstr(21 * laura_hours + 12 * mary_hours <= 193, "c33")
model.addConstr(12 * mary_hours + 31 * dale_hours <= 251, "c34")
model.addConstr(21 * laura_hours + 30 * ringo_hours + 12 * mary_hours + 31 * dale_hours <= 251, "c35")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
