
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
laura = m.addVar(name="laura", lb=0)  # hours worked by Laura
ringo = m.addVar(name="ringo", lb=0)  # hours worked by Ringo
mary = m.addVar(name="mary", lb=0)  # hours worked by Mary
dale = m.addVar(name="dale", lb=0)  # hours worked by Dale

# Define the objective function
m.setObjective(3 * laura + ringo + 3 * mary + 6 * dale, gp.GRB.MAXIMIZE)

# Constraints
# Productivity rating constraints
m.addConstr(9 * laura + 22 * dale >= 45, "prod_rating_la_dale")
m.addConstr(13 * ringo + 31 * mary >= 98, "prod_rating_ring_mary")
m.addConstr(9 * laura + 13 * ringo + 22 * dale >= 83, "prod_rating_la_ring_dale")
m.addConstr(10 * laura + 6 * mary >= 43, "dollar_cost_la_mary")
m.addConstr(6 * mary + 18 * dale >= 68, "dollar_cost_mary_dale")

# Work quality rating constraints
m.addConstr(6 * laura + 4 * dale >= 24, "work_qual_la_dale")
m.addConstr(6 * laura + 8 * mary >= 49, "work_qual_la_mary")
m.addConstr(6 * laura + 1 * ringo + 4 * dale >= 56, "work_qual_la_ring_dale")
m.addConstr(6 * laura + 1 * ringo + 8 * mary >= 56, "work_qual_la_ring_mary")
m.addConstr(6 * laura + 1 * ringo + 4 * dale >= 32, "work_qual_la_ring_dale_2")
m.addConstr(6 * laura + 1 * ringo + 8 * mary >= 32, "work_qual_la_ring_mary_2")

# Productivity rating upper bounds
m.addConstr(13 * ringo + 31 * mary <= 424, "prod_rating_ring_mary_ub")
m.addConstr(31 * mary + 22 * dale <= 336, "prod_rating_mary_dale_ub")
m.addConstr(9 * laura + 22 * dale <= 316, "prod_rating_la_dale_ub")
m.addConstr(13 * ringo + 22 * dale <= 262, "prod_rating_ring_dale_ub")
m.addConstr(9 * laura + 31 * mary <= 390, "prod_rating_la_mary_ub")
m.addConstr(13 * ringo + 31 * mary + 22 * dale <= 289, "prod_rating_ring_mary_dale_ub")
m.addConstr(9 * laura + 13 * ringo + 22 * dale <= 126, "prod_rating_la_ring_dale_ub_2")
m.addConstr(9 * laura + 13 * ringo + 31 * mary <= 211, "prod_rating_la_ring_mary_ub")
m.addConstr(9 * laura + 13 * ringo + 31 * mary + 22 * dale <= 211, "prod_rating_all_ub")

# Dollar cost per hour upper bounds
m.addConstr(10 * laura + 6 * mary <= 266, "dollar_cost_la_mary_ub")
m.addConstr(6 * mary + 18 * dale <= 166, "dollar_cost_mary_dale_ub")
m.addConstr(5 * ringo + 6 * mary <= 170, "dollar_cost_ring_mary_ub")
m.addConstr(10 * laura + 18 * dale <= 93, "dollar_cost_la_dale_ub")
m.addConstr(5 * ringo + 18 * dale <= 221, "dollar_cost_ring_dale_ub")
m.addConstr(10 * laura + 5 * ringo + 6 * mary + 18 * dale <= 221, "dollar_cost_all_ub")

# Work quality rating upper bounds
m.addConstr(1 * ringo + 8 * mary <= 60, "work_qual_ring_mary_ub")
m.addConstr(6 * laura + 8 * mary <= 71, "work_qual_la_mary_ub")
m.addConstr(1 * ringo + 8 * mary + 4 * dale <= 63, "work_qual_ring_mary_dale_ub")
m.addConstr(6 * laura + 1 * ringo + 4 * dale <= 182, "work_qual_la_ring_dale_ub_2")
m.addConstr(6 * laura + 8 * mary + 4 * dale <= 76, "work_qual_la_mary_dale_ub")
m.addConstr(6 * laura + 1 * ringo + 8 * mary + 4 * dale <= 76, "work_qual_all_ub")

# Likelihood to quit index upper bounds
m.addConstr(21 * laura + 12 * mary <= 193, "quit_la_mary_ub")
m.addConstr(12 * mary + 31 * dale <= 251, "quit_mary_dale_ub")
m.addConstr(21 * laura + 30 * ringo + 12 * mary + 31 * dale <= 251, "quit_all_ub")

# Optimize
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Laura: ", laura.varValue)
    print("Hours worked by Ringo: ", ringo.varValue)
    print("Hours worked by Mary: ", mary.varValue)
    print("Hours worked by Dale: ", dale.varValue)
else:
    print("No optimal solution found")
