
import gurobi

def optimize_nutrition():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="vitamin_B5", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B5
    x1 = model.addVar(name="vitamin_B3", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B3
    x2 = model.addVar(name="vitamin_E", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin E
    x3 = model.addVar(name="magnesium", vtype=gurobi.GRB.CONTINUOUS)  # milligrams of magnesium
    x4 = model.addVar(name="vitamin_K", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin K
    x5 = model.addVar(name="potassium", vtype=gurobi.GRB.INTEGER)  # milligrams of potassium

    # Objective function
    model.setObjective(1.95*x0 + 4.9*x1 + 4.7*x2 + 5.98*x3 + 6.81*x4 + 3.54*x5, gurobi.GRB.MINIMIZE)

    # Constraints
    # Digestive support index constraints
    model.addConstraint(2.78*x0 + 4.63*x1 + 4.35*x2 + 2.02*x3 + 0.62*x4 + 3.14*x5 >= 6)

    model.addConstraint(4.35*x2 + 3.14*x5 >= 16)
    model.addConstraint(4.63*x1 + 4.35*x2 >= 9)
    model.addConstraint(2.78*x0 + 3.14*x5 >= 9)
    model.addConstraint(2.02*x3 + 3.14*x5 >= 14)
    model.addConstraint(2.78*x0 + 2.02*x3 >= 13)
    model.addConstraint(2.78*x0 + 4.35*x2 >= 16)
    model.addConstraint(0.62*x4 + 3.14*x5 >= 12)
    model.addConstraint(4.63*x1 + 2.02*x3 >= 6)
    model.addConstraint(2.78*x0 + 4.63*x1 + 4.35*x2 + 2.02*x3 + 0.62*x4 + 3.14*x5 >= 6)

    # Energy stability index constraints
    model.addConstraint(2.15*x0 + 2.7*x4 >= 18)
    model.addConstraint(2.15*x0 + 0.58*x1 >= 15)
    model.addConstraint(0.58*x1 + 5.29*x5 >= 16)
    model.addConstraint(3.6*x2 + 2.7*x4 >= 14)
    model.addConstraint(3.6*x2 + 5.26*x3 >= 22)
    model.addConstraint(0.58*x1 + 2.7*x4 >= 13)
    model.addConstraint(5.26*x3 + 2.7*x4 >= 15)
    model.addConstraint(2.15*x0 + 5.26*x3 >= 22)
    model.addConstraint(0.58*x1 + 5.26*x3 >= 10)
    model.addConstraint(2.15*x0 + 0.58*x1 + 2.7*x4 >= 17)
    model.addConstraint(0.58*x1 + 3.6*x2 + 2.7*x4 >= 17)
    model.addConstraint(2.15*x0 + 3.6*x2 + 2.7*x4 >= 17)
    model.addConstraint(0.58*x1 + 5.26*x3 + 2.7*x4 >= 17)
    model.addConstraint(3.6*x2 + 2.7*x4 + 5.29*x5 >= 17)
    model.addConstraint(2.15*x0 + 0.58*x1 + 2.7*x4 >= 22)
    model.addConstraint(0.58*x1 + 3.6*x2 + 2.7*x4 >= 22)
    model.addConstraint(2.15*x0 + 3.6*x2 + 2.7*x4 >= 22)
    model.addConstraint(0.58*x1 + 5.26*x3 + 2.7*x4 >= 22)
    model.addConstraint(3.6*x2 + 2.7*x4 + 5.29*x5 >= 22)

    # Additional constraints
    model.addConstraint(8*x3 - 5*x4 >= 0)
    model.addConstraint(x0 + 2*x1 - 8*x4 >= 0)

    # Digestive support index upper bounds
    model.addConstraint(2.78*x0 + 2.02*x3 <= 84)
    model.addConstraint(4.63*x1 + 2.02*x3 <= 95)
    model.addConstraint(2.02*x3 + 0.62*x4 <= 76)
    model.addConstraint(2.02*x3 + 3.14*x5 <= 29)
    model.addConstraint(4.63*x1 + 3.14*x5 <= 73)
    model.addConstraint(4.35*x2 + 0.62*x4 <= 87)
    model.addConstraint(4.63*x1 + 4.35*x2 <= 95)
    model.addConstraint(2.78*x0 + 0.62*x4 <= 61)
    model.addConstraint(2.78*x0 + 4.63*x1 <= 32)
    model.addConstraint(4.35*x2 + 2.02*x3 + 0.62*x4 <= 56)
    model.addConstraint(2.78*x0 + 4.63*x1 + 4.35*x2 <= 32)
    model.addConstraint(4.63*x1 + 4.35*x2 + 0.62*x4 <= 48)
    model.addConstraint(2.02*x3 + 0.62*x4 + 3.14*x5 <= 26)
    model.addConstraint(2.78*x0 + 4.63*x1 + 0.62*x4 <= 66)
    model.addConstraint(2.78*x0 + 2.02*x3 + 0.62*x4 <= 22)
    model.addConstraint(4.63*x1 + 4.35*x2 + 3.14*x5 <= 67)
    model.addConstraint(4.63*x1 + 2.02*x3 + 3.14*x5 <= 72)

    # Energy stability index upper bounds
    model.addConstraint(3.6*x2 + 2.7*x4 + 5.29*x5 <= 117)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Vitamin B5: ", x0.varValue)
        print("Vitamin B3: ", x1.varValue)
        print("Vitamin E: ", x2.varValue)
        print("Magnesium: ", x3.varValue)
        print("Vitamin K: ", x4.varValue)
        print("Potassium: ", x5.varValue)
    else:
        print("No solution found")

optimize_nutrition()
