
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
sashimi = m.addVar(type=GRB.CONTINUOUS, name="sashimi")
pasta = m.addVar(type=GRB.INTEGER, name="bowls_of_pasta")
salad = m.addVar(type=GRB.INTEGER, name="bagged_salads")
beans = m.addVar(type=GRB.INTEGER, name="black_beans")
sandwich = m.addVar(type=GRB.INTEGER, name="ham_sandwiches")

# Set objective function
m.setObjective(2.28 * sashimi**2 + 8.55 * sashimi * pasta + 9.3 * sashimi * sandwich + 1.3 * pasta**2 + 9.02 * pasta * salad + 7.28 * pasta * beans + 2.98 * pasta * sandwich + 7.96 * salad**2 + 5.67 * salad * beans + 9.76 * beans * sandwich + 9.68 * salad, GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * sashimi + 10 * pasta + 14 * salad + 14 * beans + 8 * sandwich <= 311, "dollar_cost")
m.addConstr(4 * sashimi + 13 * pasta + 7 * salad + 13 * beans + 9 * sandwich <= 348, "sourness_index")
m.addConstr(8 * sashimi + 11 * pasta + 5 * salad + 2 * beans + 8 * sandwich <= 81, "tastiness_rating")

m.addConstr(10 * pasta**2 + 14 * beans**2 >= 56, "cost_pasta_beans")
m.addConstr(11 * sashimi + 10 * pasta >= 54, "cost_sashimi_pasta")
m.addConstr(10 * pasta + 14 * salad + 8 * sandwich >= 51, "cost_pasta_salad_sandwich")
m.addConstr(11 * sashimi + 14 * beans + 8 * sandwich >= 51, "cost_sashimi_beans_sandwich")
m.addConstr(10 * pasta + 14 * salad + 8 * sandwich >= 62, "cost_pasta_salad_sandwich_2")
m.addConstr(11 * sashimi + 14 * beans + 8 * sandwich >= 62, "cost_sashimi_beans_sandwich_2")

m.addConstr(13 * pasta**2 + 13 * beans**2 >= 38, "sourness_pasta_beans")
m.addConstr(4 * sashimi + 13 * pasta >= 49, "sourness_sashimi_pasta")
m.addConstr(13 * pasta**2 + 9 * sandwich**2 >= 33, "sourness_pasta_sandwich")
m.addConstr(4 * sashimi**2 + 13 * beans**2 >= 52, "sourness_sashimi_beans")
m.addConstr(4 * sashimi + 9 * sandwich >= 41, "sourness_sashimi_sandwich")
m.addConstr(13 * pasta + 13 * beans + 9 * sandwich >= 66, "sourness_pasta_beans_sandwich")
m.addConstr(4 * sashimi + 13 * pasta + 7 * salad >= 66, "sourness_sashimi_pasta_salad")
m.addConstr(7 * salad + 13 * beans + 9 * sandwich >= 66, "sourness_salad_beans_sandwich")
m.addConstr(13 * pasta**2 + 13 * beans**2 + 9 * sandwich**2 >= 54, "sourness_pasta_beans_sandwich_sq")
m.addConstr(4 * sashimi**2 + 13 * pasta**2 + 7 * salad**2 >= 54, "sourness_sashimi_pasta_salad_sq")
# ... (Rest of the constraints, similarly structured)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

