
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
sashimi = m.addVar(name="sashimi", lb=0)  # No lower bound specified
bowls_of_pasta = m.addVar(name="bowls_of_pasta", lb=0, integrality=gp.GRB.Integer)  
bagged_salads = m.addVar(name="bagged_salads", lb=0, integrality=gp.GRB.Integer)  
black_beans = m.addVar(name="black_beans", lb=0, integrality=gp.GRB.Integer)  
ham_sandwiches = m.addVar(name="ham_sandwiches", lb=0, integrality=gp.GRB.Integer)  

# Define the objective function
m.setObjective(2.28 * sashimi ** 2 + 8.55 * sashimi * bowls_of_pasta + 9.3 * sashimi * ham_sandwiches + 
               1.3 * bowls_of_pasta ** 2 + 9.02 * bowls_of_pasta * bagged_salads + 7.28 * bowls_of_pasta * black_beans + 
               2.98 * bowls_of_pasta * ham_sandwiches + 7.96 * bagged_salads ** 2 + 5.67 * bagged_salads * black_beans + 
               9.76 * black_beans * ham_sandwiches + 9.68 * bagged_salads, gp.GRB.MAXIMIZE)

# Cost constraints
m.addConstr(11 * sashimi + 10 * bowls_of_pasta + 14 * bagged_salads + 14 * black_beans + 8 * ham_sandwiches <= 311)
m.addConstr(10 * bowls_of_pasta ** 2 + 14 * black_beans ** 2 >= 56)
m.addConstr(11 * sashimi + 10 * bowls_of_pasta >= 54)
m.addConstr(10 * bowls_of_pasta + 14 * bagged_salads + 8 * ham_sandwiches >= 51)
m.addConstr(11 * sashimi + 14 * black_beans + 8 * ham_sandwiches >= 51)
m.addConstr(10 * bowls_of_pasta + 14 * bagged_salads + 8 * ham_sandwiches >= 62)
m.addConstr(11 * sashimi + 14 * black_beans + 8 * ham_sandwiches >= 62)

# Sourness index constraints
m.addConstr(4 * sashimi + 13 * bowls_of_pasta + 7 * bagged_salads + 13 * black_beans + 9 * ham_sandwiches >= 66)
m.addConstr(4 * sashimi + 13 * bowls_of_pasta >= 49)
m.addConstr(13 * bowls_of_pasta ** 2 + 9 * ham_sandwiches ** 2 >= 33)
m.addConstr(4 * sashimi ** 2 + 13 * black_beans ** 2 >= 52)
m.addConstr(4 * sashimi + 9 * ham_sandwiches >= 41)
m.addConstr(13 * bowls_of_pasta * black_beans + 9 * ham_sandwiches >= 66)

# Tastiness rating constraints
m.addConstr(8 * sashimi + 11 * bowls_of_pasta >= 13)
m.addConstr(8 * sashimi ** 2 + 5 * bagged_salads ** 2 >= 7)
m.addConstr(11 * bowls_of_pasta ** 2 + 2 * black_beans ** 2 >= 11)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Sashimi: ", sashimi.varValue)
    print("Bowls of pasta: ", bowls_of_pasta.varValue)
    print("Bagged salads: ", bagged_salads.varValue)
    print("Black beans: ", black_beans.varValue)
    print("Ham sandwiches: ", ham_sandwiches.varValue)
else:
    print("The model is infeasible.")
