
from gurobipy import Model, GRB

# Create a new model
model = Model("carbohydrate_optimization")

# Create variables
knishes = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="knishes")
granola_bars = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola_bars")
fruit_salads = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")

# Set objective function
model.setObjective(1 * knishes + 1 * granola_bars + 2 * fruit_salads, GRB.MAXIMIZE)

# Add constraints
model.addConstr(16 * knishes + 19 * fruit_salads >= 20, "carbohydrate_constraint1")
model.addConstr(3 * granola_bars + 19 * fruit_salads >= 15, "carbohydrate_constraint2")
model.addConstr(16 * knishes + 19 * fruit_salads <= 34, "carbohydrate_constraint3")
model.addConstr(3 * granola_bars + 19 * fruit_salads <= 64, "carbohydrate_constraint4")
model.addConstr(16 * knishes + 3 * granola_bars + 19 * fruit_salads <= 64, "carbohydrate_constraint5")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('knishes:', knishes.x)
    print('granola_bars:', granola_bars.x)
    print('fruit_salads:', fruit_salads.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

