
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
knishes = m.addVar(vtype=GRB.CONTINUOUS, name="knishes")
granola_bars = m.addVar(vtype=GRB.CONTINUOUS, name="granola_bars")
fruit_salads = m.addVar(vtype=GRB.CONTINUOUS, name="fruit_salads")

# Define the objective function
m.setObjective(1 * knishes + 1 * granola_bars + 2 * fruit_salads, GRB.MAXIMIZE)

# Add constraints
m.addConstr(16 * knishes + 19 * fruit_salads >= 20, name="knishes_and_fruit_min")
m.addConstr(3 * granola_bars + 19 * fruit_salads >= 15, name="granola_and_fruit_min")
m.addConstr(16 * knishes + 19 * fruit_salads <= 34, name="knishes_and_fruit_max")
m.addConstr(3 * granola_bars + 19 * fruit_salads <= 64, name="granola_and_fruit_max")
m.addConstr(16 * knishes + 3 * granola_bars + 19 * fruit_salads <= 69, name="total_carb_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Knishes: {knishes.x}, Granola Bars: {granola_bars.x}, Fruit Salads: {fruit_salads.x}")
else:
    print("No optimal solution found")
