
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
knishes = model.addVar(name="knishes", lb=0)  # No lower bound specified, assuming 0
granola_bars = model.addVar(name="granola_bars", lb=0)  # No lower bound specified, assuming 0
fruit_salads = model.addVar(name="fruit_salads", lb=0)  # No lower bound specified, assuming 0

# Objective function: Maximize 1 * knishes + 1 * granola bars + 2 * fruit salads
model.setObjective(knishes + granola_bars + 2 * fruit_salads, gurobi.GRB.MAXIMIZE)

# Constraints
# Carbohydrate content per item
r0_knishes = 16
r0_granola_bars = 3
r0_fruit_salads = 19

# Constraint: At least 20 grams of carbohydrates from knishes and fruit salads
model.addConstraint(r0_knishes * knishes + r0_fruit_salads * fruit_salads >= 20, name="carbohydrates_knishes_fruit_salads")

# Constraint: At least 15 grams of carbohydrates from granola bars and fruit salads
model.addConstraint(r0_granola_bars * granola_bars + r0_fruit_salads * fruit_salads >= 15, name="carbohydrates_granola_bars_fruit_salads")

# Constraint: At most 34 grams of carbohydrates from knishes and fruit salads
model.addConstraint(r0_knishes * knishes + r0_fruit_salads * fruit_salads <= 34, name="carbohydrates_knishes_fruit_salads_upper")

# Constraint: At most 64 grams of carbohydrates from granola bars and fruit salads
model.addConstraint(r0_granola_bars * granola_bars + r0_fruit_salads * fruit_salads <= 64, name="carbohydrates_granola_bars_fruit_salads_upper")

# Constraint: At most 64 grams of carbohydrates from knishes, granola bars, and fruit salads
model.addConstraint(r0_knishes * knishes + r0_granola_bars * granola_bars + r0_fruit_salads * fruit_salads <= 64, name="carbohydrates_total_upper")

# Carbohydrates upper bound for each resource
model.addConstraint(r0_knishes * knishes <= 69, name="carbohydrates_knishes_upper")
model.addConstraint(r0_granola_bars * granola_bars <= 69, name="carbohydrates_granola_bars_upper")
model.addConstraint(r0_fruit_salads * fruit_salads <= 69, name="carbohydrates_fruit_salads_upper")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Knishes: {knishes.varValue}")
    print(f"Granola Bars: {granola_bars.varValue}")
    print(f"Fruit Salads: {fruit_salads.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
