
from gurobipy import Model, GRB

# Create a new model
m = Model("Cybersecurity Optimization")

# Create variables
intrusion_analysts = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")
bandwidth = m.addVar(vtype=GRB.INTEGER, name="Mbps bandwidth allocated to monitoring")
honeypots = m.addVar(vtype=GRB.INTEGER, name="honeypots")
patches = m.addVar(vtype=GRB.INTEGER, name="patches per day")
security_engineers = m.addVar(vtype=GRB.INTEGER, name="security engineers")
security_onions = m.addVar(vtype=GRB.INTEGER, name="security onions")

# Set objective function
m.setObjective(7 * intrusion_analysts + 8 * bandwidth + 6 * honeypots + patches + security_engineers + security_onions, GRB.MAXIMIZE)

# Add constraints - Data Confidentiality Impact
m.addConstr(18.98 * patches + 19.1 * security_engineers >= 9)
m.addConstr(18.98 * patches + 19.58 * security_onions >= 25)
m.addConstr(5.18 * bandwidth + 18.98 * patches >= 9)
m.addConstr(17.59 * honeypots + 19.58 * security_onions >= 19)
m.addConstr(6.35 * intrusion_analysts + 18.98 * patches + 19.58 * security_onions >= 22)
m.addConstr(18.98 * patches + 19.1 * security_engineers <= 133)
m.addConstr(6.35 * intrusion_analysts + 5.18 * bandwidth <= 136)
m.addConstr(5.18 * bandwidth + 18.98 * patches <= 115)
m.addConstr(5.18 * bandwidth + 19.1 * security_engineers + 19.58 * security_onions <= 147)
m.addConstr(17.59 * honeypots + 18.98 * patches + 19.58 * security_onions <= 132)
m.addConstr(6.35 * intrusion_analysts + 5.18 * bandwidth + 17.59 * honeypots + 18.98 * patches + 19.1 * security_engineers + 19.58 * security_onions <= 132)
m.addConstr(6.35 * intrusion_analysts + 5.18 * bandwidth + 17.59 * honeypots + 18.98 * patches + 19.1 * security_engineers + 19.58 * security_onions <= 177) # r0 upper bound


# Add constraints - Network Latency Impact
m.addConstr(13.77 * intrusion_analysts + 14.43 * patches + 2.72 * security_onions >= 27)
m.addConstr(17.34 * bandwidth + 13.76 * honeypots + 14.43 * patches >= 27)
m.addConstr(14.43 * patches + 5.45 * security_engineers + 2.72 * security_onions >= 30)
m.addConstr(13.77 * intrusion_analysts + 14.43 * patches + 2.72 * security_onions >= 30)
m.addConstr(13.76 * honeypots + 14.43 * patches + 5.45 * security_engineers >= 30)
m.addConstr(14.43 * patches + 5.45 * security_engineers + 2.72 * security_onions >= 25)
m.addConstr(17.34 * bandwidth + 13.76 * honeypots + 14.43 * patches >= 25)
m.addConstr(13.76 * honeypots + 14.43 * patches + 5.45 * security_engineers >= 25)
m.addConstr(13.77 * intrusion_analysts + 14.43 * patches + 2.72 * security_onions >= 27)
m.addConstr(13.76 * honeypots + 14.43 * patches + 5.45 * security_engineers >= 27)

m.addConstr(13.77 * intrusion_analysts + 14.43 * patches <= 46)
m.addConstr(5.45 * security_engineers + 2.72 * security_onions <= 216)
m.addConstr(14.43 * patches + 2.72 * security_onions <= 120)
m.addConstr(17.34 * bandwidth + 5.45 * security_engineers <= 53)
m.addConstr(13.76 * honeypots + 5.45 * security_engineers <= 205)
m.addConstr(13.77 * intrusion_analysts + 17.34 * bandwidth + 13.76 * honeypots <= 141)
m.addConstr(13.77 * intrusion_analysts + 17.34 * bandwidth + 13.76 * honeypots + 14.43 * patches + 5.45 * security_engineers + 2.72 * security_onions <= 141)
m.addConstr(13.77 * intrusion_analysts + 17.34 * bandwidth + 13.76 * honeypots + 14.43 * patches + 5.45 * security_engineers + 2.72 * security_onions <= 220) # r1 upper bound


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

