
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
foods = ['ravioli', 'strips of bacon', 'knishes', 'hot dogs', 'protein bars', 'strawberries', 'green beans']
x = m.addVars(foods, lb=0.0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS)

# Set objective function
m.setObjective(5 * x['ravioli'] + 3 * x['strips of bacon'] + 9 * x['knishes'] + 4 * x['hot dogs'] + 1 * x['protein bars'] + 4 * x['strawberries'] + 3 * x['green beans'], gp.GRB.MINIMIZE)

# Add resource constraints
resource_data = {
    'r0': {'description': 'tastiness rating', 'upper_bound': 469, 'values': [8, 8, 13, 12, 9, 14, 10]},
    'r1': {'description': 'healthiness rating', 'upper_bound': 359, 'values': [5, 2, 14, 14, 7, 1, 1]},
    'r2': {'description': 'milligrams of iron', 'upper_bound': 395, 'values': [1, 5, 6, 12, 9, 14, 9]}
}

for resource, data in resource_data.items():
    m.addConstr(gp.quicksum(data['values'][i] * x[foods[i]] for i in range(len(foods))) <= data['upper_bound'], name=resource)


# Add other constraints
m.addConstr(9 * x['protein bars'] + 10 * x['green beans'] >= 29)
m.addConstr(8 * x['strips of bacon'] + 13 * x['knishes'] >= 22)
m.addConstr(14 * x['strawberries'] + 10 * x['green beans'] >= 27)
m.addConstr(13 * x['knishes'] + 9 * x['protein bars'] >= 38)
m.addConstr(8 * x['strips of bacon'] + 10 * x['green beans'] >= 42)
m.addConstr(13 * x['knishes'] + 14 * x['strawberries'] >= 24)
m.addConstr(8 * x['strips of bacon'] + 14 * x['strawberries'] >= 60)
m.addConstr(12 * x['hot dogs'] + 14 * x['strawberries'] >= 27)
m.addConstr(8 * x['strips of bacon'] + 14 * x['strawberries'] + 10 * x['green beans'] >= 57) # Most restrictive of the overlapping constraints
m.addConstr(2 * x['strips of bacon'] + 14 * x['hot dogs'] >= 25)
m.addConstr(14 * x['knishes'] + 1 * x['strawberries'] >= 50) # Most restrictive of the overlapping constraints
m.addConstr(14 * x['knishes'] + 1 * x['green beans'] >= 34)
m.addConstr(5 * x['ravioli'] + 2 * x['strips of bacon'] >= 40) # Most restrictive of the overlapping constraints
m.addConstr(7 * x['protein bars'] + 1 * x['strawberries'] >= 22)
m.addConstr(5 * x['strips of bacon'] + 14 * x['strawberries'] <= 239)
m.addConstr(5 * x['ravioli'] + 14 * x['knishes'] <= 272)
m.addConstr(12 * x['hot dogs'] + 14 * x['strawberries'] <= 161)
m.addConstr(13 * x['knishes'] + 9 * x['protein bars'] <= 405)
m.addConstr(14 * x['knishes'] + 10 * x['green beans'] <= 464)
m.addConstr(-4 * x['knishes'] + 7 * x['hot dogs'] >= 0)
m.addConstr(-8 * x['knishes'] + 9 * x['protein bars'] >= 0)
m.addConstr(2 * x['protein bars'] - 4 * x['green beans'] >= 0)
m.addConstr(5 * x['strips of bacon'] + 14 * x['strawberries'] >= 44) # Iron constraint
m.addConstr(1 * x['ravioli'] + 12 * x['hot dogs'] >= 32) # Iron constraint
m.addConstr(1 * x['ravioli'] + 9 * x['protein bars'] >= 49) # Iron constraint
m.addConstr(12 * x['hot dogs'] + 9 * x['green beans'] >= 43) # Iron constraint
m.addConstr(9 * x['protein bars'] + 14 * x['strawberries'] >= 18) # Iron constraint
m.addConstr(1 * x['ravioli'] + 14 * x['strawberries'] >= 54) # Iron constraint
m.addConstr(5 * x['strips of bacon'] + 9 * x['green beans'] >= 19) # Iron constraint
m.addConstr(5 * x['strips of bacon'] + 9 * x['green beans'] <= 68) # Iron constraint
m.addConstr(6 * x['knishes'] + 9 * x['green beans'] <= 366) # Iron constraint
m.addConstr(5 * x['strips of bacon'] + 6 * x['knishes'] <= 161) # Iron constraint
m.addConstr(1 * x['ravioli'] + 6 * x['knishes'] <= 226) # Iron constraint

#Most restrictive of overlapping constraints
m.addConstr(gp.quicksum(resource_data['r0']['values'][i] * x[foods[i]] for i in range(len(foods))) >= 57)
m.addConstr(gp.quicksum(resource_data['r1']['values'][i] * x[foods[i]] for i in range(len(foods))) >= 26)
m.addConstr(gp.quicksum(resource_data['r2']['values'][i] * x[foods[i]] for i in range(len(foods))) >= 30)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for food in foods:
        print(f"{food}: {x[food].x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

