
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
oranges = m.addVar(vtype=gp.GRB.INTEGER, name="oranges")
cheeseburgers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")

# Set objective function
m.setObjective(8 * oranges + 8 * cheeseburgers, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10.8 * oranges + 3.74 * cheeseburgers >= 20, "umami_index_min")
m.addConstr(7.17 * oranges + 0.2 * cheeseburgers >= 46, "protein_min")
m.addConstr(2 * oranges - 3 * cheeseburgers >= 0, "orange_cheeseburger_relation")
m.addConstr(10.8 * oranges + 3.74 * cheeseburgers <= 34, "umami_index_max")
m.addConstr(7.17 * oranges + 0.2 * cheeseburgers <= 156, "protein_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('oranges:', oranges.x)
    print('cheeseburgers:', cheeseburgers.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

