
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="oranges")  # Whole number of oranges
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="cheeseburgers")  # Non-integer amount of cheeseburgers

# Objective function: Minimize 8 times the quantity of oranges plus 8 times the quantity of cheeseburgers
m.setObjective(8*x0 + 8*x1, GRB.MINIMIZE)

# Constraints
# Total combined umami index >= 20
m.addConstr(10.8*x0 + 3.74*x1 >= 20, name="umami_min")

# Total combined umami index <= 34
m.addConstr(10.8*x0 + 3.74*x1 <= 34, name="umami_max")

# Total combined grams of protein >= 46
m.addConstr(7.17*x0 + 0.2*x1 >= 46, name="protein_min")

# Total combined grams of protein <= 156
m.addConstr(7.17*x0 + 0.2*x1 <= 156, name="protein_max")

# Linear constraint: 2x0 - 3x1 >= 0
m.addConstr(2*x0 - 3*x1 >= 0, name="linear_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Oranges:", x0.x)
    print("Cheeseburgers:", x1.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)

