
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    oranges = model.addVar(name="oranges", vtype=gurobi.GRB.INTEGER)
    cheeseburgers = model.addVar(name="cheeseburgers")

    # Objective function: Minimize 8 * oranges + 8 * cheeseburgers
    model.setObjective(8 * oranges + 8 * cheeseburgers, gurobi.GRB.MINIMIZE)

    # Constraints
    # Minimum combined umami index: 10.8 * oranges + 3.74 * cheeseburgers >= 20
    model.addConstr(10.8 * oranges + 3.74 * cheeseburgers >= 20, name="min_umami")

    # Maximum combined umami index: 10.8 * oranges + 3.74 * cheeseburgers <= 34
    model.addConstr(10.8 * oranges + 3.74 * cheeseburgers <= 34, name="max_umami")

    # Minimum combined protein: 7.17 * oranges + 0.2 * cheeseburgers >= 46
    model.addConstr(7.17 * oranges + 0.2 * cheeseburgers >= 46, name="min_protein")

    # Maximum combined protein: 7.17 * oranges + 0.2 * cheeseburgers <= 156
    model.addConstr(7.17 * oranges + 0.2 * cheeseburgers <= 156, name="max_protein")

    # Linear constraint: 2 * oranges - 3 * cheeseburgers >= 0
    model.addConstr(2 * oranges - 3 * cheeseburgers >= 0, name="linear_constraint")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Oranges: {oranges.varValue}")
        print(f"Cheeseburgers: {cheeseburgers.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
