
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b5 = m.addVar(lb=0, name="vitamin_b5")  # milligrams
fat = m.addVar(lb=0, name="fat")  # grams
vitamin_e = m.addVar(lb=0, name="vitamin_e")  # milligrams
iron = m.addVar(lb=0, name="iron")  # milligrams

# Set objective function
m.setObjective(3 * vitamin_b5 + 2 * fat + 3 * vitamin_e + 2 * iron, gp.GRB.MINIMIZE)

# Add constraints based on digestive support index
m.addConstr(14 * fat + 6 * vitamin_e >= 42, "digestive_support_1")
m.addConstr(4 * vitamin_b5 + 5 * iron >= 50, "digestive_support_2")
m.addConstr(14 * fat + 5 * iron >= 48, "digestive_support_3")
m.addConstr(4 * vitamin_b5 + 6 * vitamin_e >= 51, "digestive_support_4")
m.addConstr(4 * vitamin_b5 + 6 * vitamin_e + 5 * iron >= 56, "digestive_support_5")
m.addConstr(4 * vitamin_b5 + 14 * fat + 6 * vitamin_e >= 56, "digestive_support_6")
m.addConstr(14 * fat + 6 * vitamin_e + 5 * iron >= 56, "digestive_support_7")
m.addConstr(4 * vitamin_b5 + 14 * fat + 5 * iron >= 56, "digestive_support_8")
m.addConstr(4 * vitamin_b5 + 6 * vitamin_e + 5 * iron >= 56, "digestive_support_9")
m.addConstr(4 * vitamin_b5 + 14 * fat + 6 * vitamin_e >= 56, "digestive_support_10")
m.addConstr(14 * fat + 6 * vitamin_e + 5 * iron >= 56, "digestive_support_11")
m.addConstr(4 * vitamin_b5 + 14 * fat + 5 * iron >= 56, "digestive_support_12")
m.addConstr(4 * vitamin_b5 + 6 * vitamin_e + 5 * iron >= 38, "digestive_support_13")
m.addConstr(4 * vitamin_b5 + 14 * fat + 6 * vitamin_e >= 38, "digestive_support_14")
m.addConstr(14 * fat + 6 * vitamin_e + 5 * iron >= 38, "digestive_support_15")
m.addConstr(4 * vitamin_b5 + 14 * fat + 5 * iron >= 38, "digestive_support_16")
m.addConstr(4 * vitamin_b5 + 6 * vitamin_e + 5 * iron >= 33, "digestive_support_17")
m.addConstr(4 * vitamin_b5 + 14 * fat + 6 * vitamin_e >= 33, "digestive_support_18")
m.addConstr(14 * fat + 6 * vitamin_e + 5 * iron >= 33, "digestive_support_19")
m.addConstr(4 * vitamin_b5 + 14 * fat + 5 * iron >= 33, "digestive_support_20")
m.addConstr(4 * vitamin_b5 + 14 * fat + 6 * vitamin_e + 5 * iron >= 33, "digestive_support_21")


# Add constraints based on energy stability index
m.addConstr(2 * fat + 18 * iron >= 21, "energy_stability_1")
m.addConstr(2 * fat + 16 * vitamin_e >= 15, "energy_stability_2")
m.addConstr(5 * vitamin_b5 + 18 * iron >= 24, "energy_stability_3")
m.addConstr(2 * fat + 16 * vitamin_e + 18 * iron >= 21, "energy_stability_4")
m.addConstr(5 * vitamin_b5 + 2 * fat + 18 * iron >= 21, "energy_stability_5")
m.addConstr(5 * vitamin_b5 + 2 * fat + 16 * vitamin_e >= 21, "energy_stability_6")
m.addConstr(2 * fat + 16 * vitamin_e + 18 * iron >= 35, "energy_stability_7")
m.addConstr(5 * vitamin_b5 + 2 * fat + 18 * iron >= 35, "energy_stability_8")
m.addConstr(5 * vitamin_b5 + 2 * fat + 16 * vitamin_e >= 35, "energy_stability_9")
m.addConstr(2 * fat + 16 * vitamin_e + 18 * iron >= 26, "energy_stability_10")
m.addConstr(5 * vitamin_b5 + 2 * fat + 18 * iron >= 26, "energy_stability_11")
m.addConstr(5 * vitamin_b5 + 2 * fat + 16 * vitamin_e >= 26, "energy_stability_12")
m.addConstr(5 * vitamin_b5 + 2 * fat + 16 * vitamin_e + 18 * iron >= 26, "energy_stability_13")

# Additional constraints
m.addConstr(vitamin_b5 - vitamin_e >= 0, "additional_1")
m.addConstr(-vitamin_b5 + 5 * fat >= 0, "additional_2")
m.addConstr(2 * fat + 16 * vitamin_e <= 146, "additional_3")


# Add resource constraints (if applicable - these were provided in the context but not used in the problem description)
# m.addConstr(4 * vitamin_b5 + 14 * fat + 6 * vitamin_e + 5 * iron <= 257, "digestive_support_limit")
# m.addConstr(5 * vitamin_b5 + 2 * fat + 16 * vitamin_e + 18 * iron <= 150, "energy_stability_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

