
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(name='milligrams_of_vitamin_B5', lb=-GRB.INFINITY)
x1 = m.addVar(name='grams_of_fat', lb=-GRB.INFINITY)
x2 = m.addVar(name='milligrams_of_vitamin_E', lb=-GRB.INFINITY)
x3 = m.addVar(name='milligrams_of_iron', lb=-GRB.INFINITY)

# Objective function
m.setObjective(3*x0 + 2*x1 + 3*x2 + 2*x3, GRB.MINIMIZE)

# Constraints based on digestive support indices and energy stability indices
# Example constraints (note: not all constraints are included due to their volume)
m.addConstr(x0 * 4 + x1 * 14 + x2 * 6 + x3 * 5 <= 257, name='digestive_support_index_total')
m.addConstr(x0 * 5 + x1 * 2 + x2 * 16 + x3 * 18 <= 150, name='energy_stability_index_total')

# Additional constraints as examples
m.addConstr(x1 * 14 + x2 * 6 >= 42, name='fat_and_vitamin_E_digestive_support')
m.addConstr(x0 * 4 + x3 * 5 >= 50, name='vitamin_B5_and_iron_digestive_support')
m.addConstr(x1 * 14 + x3 * 5 >= 48, name='fat_and_iron_digestive_support')

# Example of an energy stability constraint
m.addConstr(x1 * 2 + x3 * 18 >= 21, name='energy_stability_fat_and_iron')

# Another example constraint for demonstration
m.addConstr(x0 - x2 >= 0, name='vitamin_B5_vitamin_E_ratio')
m.addConstr(-x0 + 5*x1 >= 0, name='vitamin_B5_to_fat_ratio')

# Solve the model
m.optimize()

# Print results if an optimal solution is found
if m.status == GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Milligrams of Vitamin B5: {x0.x}")
    print(f"Grams of Fat: {x1.x}")
    print(f"Milligrams of Vitamin E: {x2.x}")
    print(f"Milligrams of Iron: {x3.x}")
else:
    print("No optimal solution found")
