
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
milligrams_vitamin_B5 = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams_vitamin_B5")
grams_fat = m.addVar(lb=-gp.GRB.INFINITY, name="grams_fat")
milligrams_vitamin_E = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams_vitamin_E")
milligrams_iron = m.addVar(lb=-gp.GRB.INFINITY, name="milligrams_iron")

# Objective function
m.setObjective(3 * milligrams_vitamin_B5 + 2 * grams_fat + 3 * milligrams_vitamin_E + 2 * milligrams_iron)

# Constraints
# Digestive support index constraints
m.addConstr(14 * grams_fat + 6 * milligrams_vitamin_E >= 42)
m.addConstr(4 * milligrams_vitamin_B5 + 5 * milligrams_iron >= 50)
m.addConstr(14 * grams_fat + 5 * milligrams_iron >= 48)
m.addConstr(4 * milligrams_vitamin_B5 + 6 * milligrams_vitamin_E >= 51)
m.addConstr(4 * milligrams_vitamin_B5 + 6 * milligrams_vitamin_E + 5 * milligrams_iron >= 56)
m.addConstr(4 * milligrams_vitamin_B5 + 14 * grams_fat + 6 * milligrams_vitamin_E >= 56)
m.addConstr(14 * grams_fat + 6 * milligrams_vitamin_E + 5 * milligrams_iron >= 56)
m.addConstr(4 * milligrams_vitamin_B5 + 14 * grams_fat + 5 * milligrams_iron >= 56)
m.addConstr(4 * milligrams_vitamin_B5 + 6 * milligrams_vitamin_E + 5 * milligrams_iron >= 56)
m.addConstr(4 * milligrams_vitamin_B5 + 14 * grams_fat + 6 * milligrams_vitamin_E >= 56)
m.addConstr(14 * grams_fat + 6 * milligrams_vitamin_E + 5 * milligrams_iron >= 56)

# Lower bound constraints for digestive support
m.addConstr(4 * milligrams_vitamin_B5 + 6 * milligrams_vitamin_E + 5 * milligrams_iron >= 38)
m.addConstr(4 * milligrams_vitamin_B5 + 14 * grams_fat + 6 * milligrams_vitamin_E >= 38)
m.addConstr(14 * grams_fat + 6 * milligrams_vitamin_E + 5 * milligrams_iron >= 38)
m.addConstr(4 * milligrams_vitamin_B5 + 14 * grams_fat + 5 * milligrams_iron >= 38)
m.addConstr(4 * milligrams_vitamin_B5 + 6 * milligrams_vitamin_E + 5 * milligrams_iron >= 33)
m.addConstr(4 * milligrams_vitamin_B5 + 14 * grams_fat + 6 * milligrams_vitamin_E >= 33)
m.addConstr(14 * grams_fat + 6 * milligrams_vitamin_E + 5 * milligrams_iron >= 33)
m.addConstr(4 * milligrams_vitamin_B5 + 14 * grams_fat + 5 * milligrams_iron >= 33)
m.addConstr(4 * milligrams_vitamin_B5 + 14 * grams_fat + 6 * milligrams_vitamin_E + 5 * milligrams_iron >= 33)

# Energy stability index constraints
m.addConstr(2 * grams_fat + 18 * milligrams_iron >= 21)
m.addConstr(2 * grams_fat + 16 * milligrams_vitamin_E >= 15)
m.addConstr(5 * milligrams_vitamin_B5 + 18 * milligrams_iron >= 24)
m.addConstr(2 * grams_fat + 16 * milligrams_vitamin_E + 18 * milligrams_iron >= 21)
m.addConstr(5 * milligrams_vitamin_B5 + 2 * grams_fat + 18 * milligrams_iron >= 21)
m.addConstr(5 * milligrams_vitamin_B5 + 2 * grams_fat + 16 * milligrams_vitamin_E >= 21)
m.addConstr(2 * grams_fat + 16 * milligrams_vitamin_E + 18 * milligrams_iron >= 35)
m.addConstr(5 * milligrams_vitamin_B5 + 2 * grams_fat + 18 * milligrams_iron >= 35)
m.addConstr(5 * milligrams_vitamin_B5 + 2 * grams_fat + 16 * milligrams_vitamin_E >= 35)
m.addConstr(2 * grams_fat + 16 * milligrams_vitamin_E + 18 * milligrams_iron >= 26)
m.addConstr(5 * milligrams_vitamin_B5 + 2 * grams_fat + 18 * milligrams_iron >= 26)
m.addConstr(5 * milligrams_vitamin_B5 + 2 * grams_fat + 16 * milligrams_vitamin_E >= 26)
m.addConstr(5 * milligrams_vitamin_B5 + 2 * grams_fat + 16 * milligrams_vitamin_E + 18 * milligrams_iron >= 26)

# Additional constraints
m.addConstr(milligrams_vitamin_B5 - milligrams_vitamin_E >= 0)
m.addConstr(-milligrams_vitamin_B5 + 5 * grams_fat >= 0)
m.addConstr(2 * grams_fat + 16 * milligrams_vitamin_E <= 146)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B5: {milligrams_vitamin_B5.varValue}")
    print(f"Grams of fat: {grams_fat.varValue}")
    print(f"Milligrams of vitamin E: {milligrams_vitamin_E.varValue}")
    print(f"Milligrams of iron: {milligrams_iron.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
