
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Work Hours Cost")

# Create variables
jean_hours = model.addVar(lb=0, name="jean_hours")
ringo_hours = model.addVar(lb=0, name="ringo_hours")
john_hours = model.addVar(lb=0, name="john_hours")
george_hours = model.addVar(lb=0, name="george_hours")

# Set objective function
model.setObjective(7.35 * jean_hours**2 + 9.5 * jean_hours * john_hours + 5.13 * jean_hours * george_hours + 5.59 * ringo_hours**2 + 6.13 * john_hours * george_hours + 8.95 * george_hours**2 + 9.56 * jean_hours + 6.49 * ringo_hours + 1.6 * john_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(7.4 * jean_hours**2 + 3.4 * george_hours**2 >= 23, "c1")
model.addConstr(1.99 * ringo_hours + 2.67 * john_hours >= 33, "c2")
model.addConstr(7.4 * jean_hours**2 + 1.99 * ringo_hours**2 >= 20, "c3")
model.addConstr(7.4 * jean_hours**2 + 2.67 * john_hours**2 >= 20, "c4")
model.addConstr(7.4 * jean_hours + 1.99 * ringo_hours + 2.67 * john_hours + 3.4 * george_hours >= 20, "c5")
model.addConstr(1.5 * john_hours**2 + 2.16 * george_hours**2 >= 49, "c6")
model.addConstr(0.29 * jean_hours + 1.5 * john_hours >= 36, "c7")
model.addConstr(7.73 * ringo_hours + 1.5 * john_hours >= 56, "c8")
model.addConstr(7.73 * ringo_hours + 2.16 * george_hours >= 28, "c9")
model.addConstr(0.29 * jean_hours**2 + 2.16 * george_hours**2 >= 57, "c10")
model.addConstr(0.29 * jean_hours**2 + 1.5 * john_hours**2 + 2.16 * george_hours**2 >= 50, "c11")
model.addConstr(0.29 * jean_hours + 7.73 * ringo_hours + 1.5 * john_hours + 2.16 * george_hours >= 50, "c12")
model.addConstr(7 * ringo_hours - 8 * george_hours >= 0, "c13")
model.addConstr(3 * jean_hours - 7 * john_hours >= 0, "c14")
model.addConstr(7.4 * jean_hours**2 + 2.67 * john_hours**2 + 3.4 * george_hours**2 <= 209, "c15")
model.addConstr(7.73 * ringo_hours + 1.5 * john_hours <= 206, "c16")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Jean Hours: %g' % jean_hours.x)
    print('Ringo Hours: %g' % ringo_hours.x)
    print('John Hours: %g' % john_hours.x)
    print('George Hours: %g' % george_hours.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
