
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
jean = m.addVar(lb=0, name="jean")
ringo = m.addVar(lb=0, name="ringo")
john = m.addVar(lb=0, name="john")
george = m.addVar(lb=0, name="george")

# Define the objective function
m.setObjective(7.35 * jean**2 + 9.5 * jean * john + 5.13 * jean * george + 
               5.59 * ringo**2 + 6.13 * john * george + 8.95 * george**2 + 
               9.56 * jean + 6.49 * ringo + 1.6 * john, gurobi.GRB.MINIMIZE)

# Define the constraints
m.addConstr(jean == 7.4, name="jean_productivity")
m.addConstr(jean * 0.29 == 0.29, name="jean_likelihood")
m.addConstr(ringo == 1.99, name="ringo_productivity")
m.addConstr(ringo * 7.73 == 7.73, name="ringo_likelihood")
m.addConstr(john == 2.67, name="john_productivity")
m.addConstr(john * 1.5 == 1.5, name="john_likelihood")
m.addConstr(george == 3.4, name="george_productivity")
m.addConstr(george * 2.16 == 2.16, name="george_likelihood")

m.addConstr(jean**2 + george**2 >= 23, name="productivity_jean_george")
m.addConstr(ringo + john >= 33, name="productivity_ringo_john")
m.addConstr(jean**2 + ringo**2 >= 20, name="productivity_jean_ringo")
m.addConstr(jean**2 + john**2 >= 20, name="productivity_jean_john")
m.addConstr(jean + ringo + john + george >= 20, name="productivity_total")

m.addConstr(john**2 + george**2 >= 49, name="likelihood_john_george")
m.addConstr(jean + john >= 36, name="likelihood_jean_john")
m.addConstr(ringo + john >= 56, name="likelihood_ringo_john")
m.addConstr(ringo + george >= 28, name="likelihood_ringo_george")
m.addConstr(jean**2 + george**2 >= 57, name="likelihood_jean_george")
m.addConstr(jean**2 + john**2 + george**2 >= 50, name="likelihood_jean_john_george")
m.addConstr(jean + ringo + john + george >= 50, name="likelihood_total")

m.addConstr(7 * ringo - 8 * george >= 0, name="ringo_george")
m.addConstr(3 * jean - 7 * john >= 0, name="jean_john")

m.addConstr(jean**2 + john**2 + george**2 <= 209, name="productivity_max")
m.addConstr(ringo + john <= 206, name="likelihood_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by Jean:", jean.varValue)
    print("Hours worked by Ringo:", ringo.varValue)
    print("Hours worked by John:", john.varValue)
    print("Hours worked by George:", george.varValue)
else:
    print("No optimal solution found.")
