
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_c = model.addVar(vtype=GRB.INTEGER, name="vitamin_c")
vitamin_b7 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b7")
calcium = model.addVar(vtype=GRB.CONTINUOUS, name="calcium")
zinc = model.addVar(vtype=GRB.CONTINUOUS, name="zinc")
iron = model.addVar(vtype=GRB.CONTINUOUS, name="iron")

# Set objective function
model.setObjective(4.7 * vitamin_c * vitamin_b7 + 4.74 * vitamin_c * calcium + 4.47 * vitamin_c * zinc + 2.41 * vitamin_c * iron + 2.43 * vitamin_b7 * vitamin_b7 + 2.22 * vitamin_b7 * calcium + 6.39 * calcium * calcium + 2.88 * calcium * zinc + 7.35 * iron * iron + 6.99 * vitamin_b7 + 3.22 * iron, GRB.MAXIMIZE)

# Add constraints
model.addConstr(1.69 * vitamin_c + 1.15 * zinc + 1.92 * iron >= 57, "kidney_constraint1")
model.addConstr(1.69 * vitamin_c + 1.14 * vitamin_b7 + 1.92 * iron >= 57, "kidney_constraint2")
model.addConstr(1.69 * vitamin_c + 1.15 * zinc + 1.92 * iron >= 55, "kidney_constraint3")
model.addConstr(1.69 * vitamin_c + 1.14 * vitamin_b7 + 1.92 * iron >= 55, "kidney_constraint4")

model.addConstr(1.69 * vitamin_c + 1.14 * vitamin_b7 <= 260, "kidney_constraint5")
model.addConstr(1.14 * vitamin_b7 + 0.14 * calcium <= 90, "kidney_constraint6")
model.addConstr(1.14 * vitamin_b7 * vitamin_b7 + 1.92 * iron * iron <= 112, "kidney_constraint7")
model.addConstr(1.69 * vitamin_c + 1.14 * vitamin_b7 + 0.14 * calcium <= 183, "kidney_constraint8")
model.addConstr(0.14 * calcium + 1.15 * zinc + 1.92 * iron <= 223, "kidney_constraint9")
model.addConstr(1.69 * vitamin_c + 1.14 * vitamin_b7 + 1.15 * zinc <= 176, "kidney_constraint10")
model.addConstr(1.14 * vitamin_b7 * vitamin_b7 + 0.14 * calcium * calcium + 1.92 * iron * iron <= 168, "kidney_constraint11")
model.addConstr(1.69 * vitamin_c * vitamin_c + 0.14 * calcium * calcium + 1.15 * zinc * zinc <= 236, "kidney_constraint12")
model.addConstr(1.69 * vitamin_c + 1.14 * vitamin_b7 + 0.14 * calcium + 1.15 * zinc + 1.92 * iron <= 236, "kidney_constraint13")


model.addConstr(0.85 * vitamin_c + 1.9 * calcium + 0.56 * zinc >= 35, "energy_constraint1")
model.addConstr(0.85 * vitamin_c + 1.9 * calcium + 1.25 * iron >= 35, "energy_constraint2")
model.addConstr(1.28 * vitamin_b7 * vitamin_b7 + 1.9 * calcium * calcium + 1.25 * iron * iron >= 35, "energy_constraint3")
model.addConstr(1.28 * vitamin_b7 + 1.9 * calcium + 0.56 * zinc >= 35, "energy_constraint4")
model.addConstr(0.85 * vitamin_c + 1.28 * vitamin_b7 + 0.56 * zinc >= 35, "energy_constraint5")

model.addConstr(0.85 * vitamin_c + 1.9 * calcium + 0.56 * zinc >= 68, "energy_constraint6")
model.addConstr(0.85 * vitamin_c + 1.9 * calcium + 1.25 * iron >= 68, "energy_constraint7")
model.addConstr(1.28 * vitamin_b7 + 1.9 * calcium + 1.25 * iron >= 68, "energy_constraint8")
model.addConstr(1.28 * vitamin_b7 + 1.9 * calcium + 0.56 * zinc >= 68, "energy_constraint9")
model.addConstr(0.85 * vitamin_c + 1.28 * vitamin_b7 + 0.56 * zinc >= 68, "energy_constraint10")
model.addConstr(0.85 * vitamin_c + 1.9 * calcium + 0.56 * zinc >= 68, "energy_constraint11") # Redundant
model.addConstr(0.85 * vitamin_c * vitamin_c + 1.9 * calcium * calcium + 1.25 * iron * iron >= 68, "energy_constraint12")
model.addConstr(1.28 * vitamin_b7 + 1.9 * calcium + 1.25 * iron >= 68, "energy_constraint13") # Redundant
model.addConstr(1.28 * vitamin_b7 + 1.9 * calcium + 0.56 * zinc >= 68, "energy_constraint14") # Redundant
model.addConstr(0.85 * vitamin_c + 1.28 * vitamin_b7 + 0.56 * zinc >= 68, "energy_constraint15") # Redundant

model.addConstr(0.85 * vitamin_c * vitamin_c + 1.9 * calcium * calcium + 0.56 * zinc * zinc >= 63, "energy_constraint16")
model.addConstr(0.85 * vitamin_c + 1.9 * calcium + 1.25 * iron >= 63, "energy_constraint17")
model.addConstr(1.28 * vitamin_b7 + 1.9 * calcium + 1.25 * iron >= 63, "energy_constraint18")
model.addConstr(1.28 * vitamin_b7 * vitamin_b7 + 1.9 * calcium * calcium + 0.56 * zinc * zinc >= 63, "energy_constraint19")
model.addConstr(0.85 * vitamin_c * vitamin_c + 1.28 * vitamin_b7 * vitamin_b7 + 0.56 * zinc * zinc >= 63, "energy_constraint20")

model.addConstr(0.85 * vitamin_c * vitamin_c + 1.9 * calcium * calcium + 0.56 * zinc * zinc >= 39, "energy_constraint21")
model.addConstr(0.85 * vitamin_c * vitamin_c + 1.9 * calcium * calcium + 1.25 * iron * iron >= 39, "energy_constraint22")
model.addConstr(1.28 * vitamin_b7 * vitamin_b7 + 1.9 * calcium * calcium + 1.25 * iron * iron >= 39, "energy_constraint23") # Redundant
model.addConstr(1.28 * vitamin_b7 + 1.9 * calcium + 0.56 * zinc >= 39, "energy_constraint24") # Redundant
model.addConstr(0.85 * vitamin_c + 1.28 * vitamin_b7 + 0.56 * zinc >= 39, "energy_constraint25") # Redundant


model.addConstr(0.85 * vitamin_c + 1.28 * vitamin_b7 <= 107, "energy_constraint26")
model.addConstr(1.28 * vitamin_b7 + 1.25 * iron <= 336, "energy_constraint27")
model.addConstr(1.9 * calcium * calcium + 0.56 * zinc * zinc <= 68, "energy_constraint28")
model.addConstr(0.85 * vitamin_c * vitamin_c + 1.25 * iron * iron <= 182, "energy_constraint29")
model.addConstr(1.28 * vitamin_b7 * vitamin_b7 + 1.9 * calcium * calcium + 0.56 * zinc * zinc <= 199, "energy_constraint30")
model.addConstr(0.85 * vitamin_c * vitamin_c + 1.28 * vitamin_b7 * vitamin_b7 + 0.56 * zinc * zinc <= 143, "energy_constraint31")
model.addConstr(1.9 * calcium * calcium + 0.56 * zinc * zinc + 1.25 * iron * iron <= 253, "energy_constraint32")
model.addConstr(0.85 * vitamin_c + 1.9 * calcium + 1.25 * iron <= 230, "energy_constraint33")
model.addConstr(0.85 * vitamin_c + 1.28 * vitamin_b7 + 1.9 * calcium + 0.56 * zinc + 1.25 * iron <= 230, "energy_constraint34")



model.addConstr(-9 * vitamin_b7 + 3 * iron >= 0, "constraint_1")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Vitamin C: %g' % vitamin_c.x)
    print('Vitamin B7: %g' % vitamin_b7.x)
    print('Calcium: %g' % calcium.x)
    print('Zinc: %g' % zinc.x)
    print('Iron: %g' % iron.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
