
import gurobipy as gp

# Create a new model
model = gp.Model("Resource_Allocation")

# Create variables
scissors = model.addVar(vtype=gp.GRB.INTEGER, name="scissors")
paper = model.addVar(vtype=gp.GRB.INTEGER, name="packs_of_paper")
highlighters = model.addVar(vtype=gp.GRB.INTEGER, name="red_highlighters")
pencils = model.addVar(vtype=gp.GRB.INTEGER, name="wooden_pencils")

# Set objective function
model.setObjective(9 * scissors + 5 * paper + 3 * highlighters + 8 * pencils, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(18 * paper + 24 * highlighters >= 93, "c1")
model.addConstr(18 * paper + 1 * pencils >= 77, "c2")
model.addConstr(32 * scissors + 1 * pencils >= 46, "c3")
model.addConstr(18 * paper + 24 * highlighters + 1 * pencils >= 106, "c4")
model.addConstr(32 * scissors + 18 * paper + 1 * pencils >= 106, "c5")
model.addConstr(32 * scissors + 18 * paper + 24 * highlighters >= 106, "c6")
model.addConstr(18 * paper + 24 * highlighters + 1 * pencils >= 59, "c7")
model.addConstr(32 * scissors + 18 * paper + 1 * pencils >= 59, "c8")
model.addConstr(32 * scissors + 18 * paper + 24 * highlighters >= 59, "c9")
model.addConstr(18 * paper + 24 * highlighters + 1 * pencils >= 68, "c10")
model.addConstr(32 * scissors + 18 * paper + 1 * pencils >= 68, "c11")
model.addConstr(32 * scissors + 18 * paper + 24 * highlighters >= 68, "c12")
model.addConstr(32 * scissors + 18 * paper + 24 * highlighters + 1 * pencils >= 68, "c13")
model.addConstr(-3 * scissors + 7 * paper >= 0, "c14")
model.addConstr(7 * scissors - 1 * pencils >= 0, "c15")
model.addConstr(18 * paper + 1 * pencils <= 363, "c16")
model.addConstr(32 * scissors + 1 * pencils <= 126, "c17")
model.addConstr(32 * scissors + 18 * paper <= 283, "c18")
model.addConstr(18 * paper + 24 * highlighters <= 365, "c19")
model.addConstr(24 * highlighters + 1 * pencils <= 243, "c20")
model.addConstr(32 * scissors + 18 * paper + 24 * highlighters + pencils <= 456, "c21")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('scissors:', scissors.x)
    print('paper:', paper.x)
    print('highlighters:', highlighters.x)
    print('pencils:', pencils.x)
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

