
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    scissors = model.addVar(name="scissors", vtype=gurobi.GRB.INTEGER)
    packs_of_paper = model.addVar(name="packs_of_paper", vtype=gurobi.GRB.INTEGER)
    red_highlighters = model.addVar(name="red_highlighters", vtype=gurobi.GRB.INTEGER)
    wooden_pencils = model.addVar(name="wooden_pencils", vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize 9*scissors + 5*packs_of_paper + 3*red_highlighters + 8*wooden_pencils
    model.setObjective(9 * scissors + 5 * packs_of_paper + 3 * red_highlighters + 8 * wooden_pencils, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(32 * scissors + 18 * packs_of_paper + 24 * red_highlighters + wooden_pencils <= 456, "Employee Satisfaction Impact")

    model.addConstr(18 * packs_of_paper + 24 * red_highlighters >= 93, "Min Impact packs of paper + red highlighters")
    model.addConstr(18 * packs_of_paper + wooden_pencils >= 77, "Min Impact packs of paper + wooden pencils")
    model.addConstr(32 * scissors + wooden_pencils >= 46, "Min Impact scissors + wooden pencils")
    model.addConstr(18 * packs_of_paper + 24 * red_highlighters + wooden_pencils >= 106, "Min Impact packs of paper + red highlighters + wooden pencils")
    model.addConstr(32 * scissors + 18 * packs_of_paper + wooden_pencils >= 106, "Min Impact scissors + packs of paper + wooden pencils")
    model.addConstr(32 * scissors + 18 * packs_of_paper + 24 * red_highlighters >= 106, "Min Impact scissors + packs of paper + red highlighters")

    model.addConstr(18 * packs_of_paper + 24 * red_highlighters + wooden_pencils >= 59, "Min Impact Total")
    model.addConstr(32 * scissors + 18 * packs_of_paper + wooden_pencils >= 59, "Min Impact scissors + packs of paper + wooden pencils")
    model.addConstr(32 * scissors + 18 * packs_of_paper + 24 * red_highlighters >= 59, "Min Impact scissors + packs of paper + red highlighters")
    model.addConstr(32 * scissors + 18 * packs_of_paper + 24 * red_highlighters + wooden_pencils >= 68, "Min Impact Total >= 68")

    model.addConstr(-3 * scissors + 7 * packs_of_paper >= 0, "Linear Constraint 1")
    model.addConstr(7 * scissors - wooden_pencils >= 0, "Linear Constraint 2")

    model.addConstr(18 * packs_of_paper + wooden_pencils <= 363, "Upper Bound packs of paper + wooden pencils")
    model.addConstr(32 * scissors + wooden_pencils <= 126, "Upper Bound scissors + wooden pencils")
    model.addConstr(32 * scissors + 18 * packs_of_paper <= 283, "Upper Bound scissors + packs of paper")
    model.addConstr(18 * packs_of_paper + 24 * red_highlighters <= 365, "Upper Bound packs of paper + red highlighters")
    model.addConstr(24 * red_highlighters + wooden_pencils <= 243, "Upper Bound red highlighters + wooden pencils")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Scissors: ", scissors.varValue)
        print("Packs of Paper: ", packs_of_paper.varValue)
        print("Red Highlighters: ", red_highlighters.varValue)
        print("Wooden Pencils: ", wooden_pencils.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
