
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
eggs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="eggs")
fruit_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
kiwis = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kiwis")
apple_pies = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")

# Set objective function
m.setObjective(4 * eggs + 9 * fruit_salads + 9 * kiwis + 2 * apple_pies, GRB.MINIMIZE)

# Add constraints
m.addConstr(28 * fruit_salads + 34 * kiwis >= 67, "c0")
m.addConstr(24 * eggs + 28 * fruit_salads + 14 * apple_pies >= 44, "c1")
m.addConstr(24 * eggs + 28 * fruit_salads + 34 * kiwis + 14 * apple_pies >= 44, "c2")
m.addConstr(6 * eggs + 14 * fruit_salads >= 51, "c3")
m.addConstr(6 * eggs + 20 * kiwis >= 81, "c4")
m.addConstr(6 * eggs + 14 * fruit_salads + 24 * apple_pies >= 58, "c5")
m.addConstr(6 * eggs + 14 * fruit_salads + 20 * kiwis + 24 * apple_pies >= 58, "c6")
m.addConstr(32 * kiwis + 1 * apple_pies >= 31, "c7")
m.addConstr(6 * eggs + 11 * fruit_salads + 1 * apple_pies >= 37, "c8")
m.addConstr(11 * fruit_salads + 32 * kiwis + 1 * apple_pies >= 37, "c9")
m.addConstr(6 * eggs + 32 * kiwis + 1 * apple_pies >= 37, "c10")
m.addConstr(6 * eggs + 11 * fruit_salads + 1 * apple_pies >= 48, "c11")
m.addConstr(11 * fruit_salads + 32 * kiwis + 1 * apple_pies >= 48, "c12")
m.addConstr(6 * eggs + 32 * kiwis + 1 * apple_pies >= 48, "c13")
m.addConstr(6 * eggs + 11 * fruit_salads + 1 * apple_pies >= 52, "c14")
m.addConstr(11 * fruit_salads + 32 * kiwis + 1 * apple_pies >= 52, "c15")
m.addConstr(6 * eggs + 32 * kiwis + 1 * apple_pies >= 52, "c16")
m.addConstr(6 * eggs + 11 * fruit_salads + 32 * kiwis + 1 * apple_pies >= 52, "c17")
m.addConstr(18 * eggs + 23 * fruit_salads >= 42, "c18")
m.addConstr(18 * eggs + 24 * kiwis >= 33, "c19")
m.addConstr(24 * kiwis + 26 * apple_pies >= 21, "c20")
m.addConstr(18 * eggs + 26 * apple_pies >= 20, "c21")
m.addConstr(18 * eggs + 24 * kiwis + 26 * apple_pies >= 29, "c22")
m.addConstr(18 * eggs + 23 * fruit_salads + 24 * kiwis + 26 * apple_pies >= 29, "c23")
m.addConstr(10 * eggs - 3 * apple_pies >= 0, "c24")
m.addConstr(2 * eggs - 4 * kiwis >= 0, "c25")
m.addConstr(28 * fruit_salads + 34 * kiwis <= 274, "c26")
m.addConstr(20 * kiwis + 24 * apple_pies <= 265, "c27")
m.addConstr(14 * fruit_salads + 24 * apple_pies <= 351, "c28")
m.addConstr(6 * eggs + 14 * fruit_salads <= 240, "c29")
m.addConstr(14 * fruit_salads + 20 * kiwis + 24 * apple_pies <= 186, "c30")
m.addConstr(6 * eggs + 14 * fruit_salads + 24 * apple_pies <= 253, "c31")
m.addConstr(6 * eggs + 14 * fruit_salads + 20 * kiwis <= 283, "c32")
m.addConstr(6 * eggs + 11 * fruit_salads + 1 * apple_pies <= 137, "c33")
m.addConstr(11 * fruit_salads + 32 * kiwis + 1 * apple_pies <= 140, "c34")
m.addConstr(18 * eggs + 26 * apple_pies <= 53, "c35")
m.addConstr(18 * eggs + 24 * kiwis + 26 * apple_pies <= 84, "c36")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

