
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
eggs = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="eggs")
fruit_salads = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="fruit_salads")
kiwis = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="kiwis")
apple_pies = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="apple_pies")

# Define the objective function
m.setObjective(4 * eggs + 9 * fruit_salads + 9 * kiwis + 2 * apple_pies, GRB.MINIMIZE)

# Sourness index constraints
m.addConstr(24 * eggs + 28 * fruit_salads + 34 * kiwis + 14 * apple_pies >= 44)
m.addConstr(24 * eggs + 28 * fruit_salads + 34 * kiwis + 14 * apple_pies >= 44)
m.addConstr(28 * fruit_salads + 34 * kiwis >= 67)

# Fiber content constraints
m.addConstr(6 * eggs + 14 * fruit_salads >= 51)
m.addConstr(6 * eggs + 20 * kiwis >= 81)
m.addConstr(6 * eggs + 14 * fruit_salads + 24 * apple_pies >= 58)
m.addConstr(6 * eggs + 14 * fruit_salads + 20 * kiwis + 24 * apple_pies >= 58)

# Calcium content constraints
m.addConstr(32 * kiwis + 1 * apple_pies >= 31)
m.addConstr(6 * eggs + 11 * fruit_salads + 1 * apple_pies >= 37)
m.addConstr(11 * fruit_salads + 32 * kiwis + 1 * apple_pies >= 37)
m.addConstr(6 * eggs + 32 * kiwis + 1 * apple_pies >= 37)

# Tastiness rating constraints
m.addConstr(18 * eggs + 23 * fruit_salads >= 42)
m.addConstr(18 * eggs + 24 * kiwis >= 33)
m.addConstr(24 * kiwis + 26 * apple_pies >= 21)
m.addConstr(18 * eggs + 26 * apple_pies >= 20)

# Additional linear constraints
m.addConstr(10 * eggs - 3 * apple_pies >= 0)
m.addConstr(2 * eggs - 4 * kiwis >= 0)

# Upper bound constraints
m.addConstr(28 * fruit_salads + 34 * kiwis <= 274)
m.addConstr(20 * kiwis + 24 * apple_pies <= 265)
m.addConstr(14 * fruit_salads + 24 * apple_pies <= 351)
m.addConstr(6 * eggs + 14 * fruit_salads <= 240)
m.addConstr(14 * fruit_salads + 20 * kiwis + 24 * apple_pies <= 186)

# Optimize the model
m.optimize()
