
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
eggs = m.addVar(name="eggs", lb=0)
fruit_salads = m.addVar(name="fruit_salads", lb=0)
kiwis = m.addVar(name="kiwis", lb=0)
apple_pies = m.addVar(name="apple_pies", lb=0)

# Define the objective function
m.setObjective(4 * eggs + 9 * fruit_salads + 9 * kiwis + 2 * apple_pies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(24 * eggs <= 347, name="sourness_eggs")
m.addConstr(6 * eggs + 14 * fruit_salads + 20 * kiwis + 24 * apple_pies <= 356, name="fiber_total")
m.addConstr(6 * eggs + 11 * fruit_salads + 32 * kiwis + apple_pies <= 213, name="calcium_total")
m.addConstr(18 * eggs + 23 * fruit_salads + 24 * kiwis + 26 * apple_pies <= 213, name="tastiness_total")

m.addConstr(28 * fruit_salads + 34 * kiwis >= 67, name="sourness_fruit_salads_kiwis")
m.addConstr(24 * eggs + 28 * fruit_salads + 14 * apple_pies >= 44, name="sourness_eggs_fruit_salads_apple_pies")
m.addConstr(24 * eggs + 28 * fruit_salads + 34 * kiwis + 14 * apple_pies >= 44, name="sourness_total")

m.addConstr(6 * eggs + 14 * fruit_salads >= 51, name="fiber_eggs_fruit_salads")
m.addConstr(6 * eggs + 20 * kiwis >= 81, name="fiber_eggs_kiwis")
m.addConstr(6 * eggs + 14 * fruit_salads + 24 * apple_pies >= 58, name="fiber_eggs_fruit_salads_apple_pies")
m.addConstr(6 * eggs + 14 * fruit_salads + 20 * kiwis + 24 * apple_pies >= 58, name="fiber_total_eggs_fruit_salads_kiwis_apple_pies")

m.addConstr(32 * kiwis + apple_pies >= 31, name="calcium_kiwis_apple_pies")
m.addConstr(6 * eggs + 11 * fruit_salads + apple_pies >= 37, name="calcium_eggs_fruit_salads_apple_pies")
m.addConstr(11 * fruit_salads + 32 * kiwis + apple_pies >= 37, name="calcium_fruit_salads_kiwis_apple_pies")
m.addConstr(6 * eggs + 32 * kiwis + apple_pies >= 37, name="calcium_eggs_kiwis_apple_pies")

m.addConstr(18 * eggs + 23 * fruit_salads >= 42, name="tastiness_eggs_fruit_salads")
m.addConstr(18 * eggs + 24 * kiwis >= 33, name="tastiness_eggs_kiwis")
m.addConstr(24 * kiwis + 26 * apple_pies >= 21, name="tastiness_kiwis_apple_pies")
m.addConstr(18 * eggs + 26 * apple_pies >= 20, name="tastiness_eggs_apple_pies")

m.addConstr(10 * eggs - 3 * apple_pies >= 0, name="eggs_apple_pies")
m.addConstr(2 * eggs - 4 * kiwis >= 0, name="eggs_kiwis")

m.addConstr(28 * fruit_salads + 34 * kiwis <= 274, name="sourness_fruit_salads_kiwis_max")
m.addConstr(20 * kiwis + 24 * apple_pies <= 265, name="fiber_kiwis_apple_pies_max")
m.addConstr(14 * fruit_salads + 24 * apple_pies <= 351, name="fiber_fruit_salads_apple_pies_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Eggs: ", eggs.varValue)
    print("Fruit Salads: ", fruit_salads.varValue)
    print("Kiwis: ", kiwis.varValue)
    print("Apple Pies: ", apple_pies.varValue)
else:
    print("The model is infeasible")
