
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize_Work_Hours_Cost")

# Create variables
george_hours = model.addVar(vtype=GRB.INTEGER, name="george_hours")
john_hours = model.addVar(vtype=GRB.CONTINUOUS, name="john_hours")
mary_hours = model.addVar(vtype=GRB.CONTINUOUS, name="mary_hours")
bobby_hours = model.addVar(vtype=GRB.CONTINUOUS, name="bobby_hours")

# Set objective function
model.setObjective(8.77 * george_hours + 6.24 * john_hours + 4.31 * mary_hours + 8.4 * bobby_hours, GRB.MINIMIZE)

# Add constraints based on the provided resources and attributes
computer_competence = {'George': 5, 'John': 5, 'Mary': 8, 'Bobby': 10}
organization_score = {'George': 10, 'John': 14, 'Mary': 8, 'Bobby': 13}
productivity_rating = {'George': 4, 'John': 11, 'Mary': 7, 'Bobby': 6}
likelihood_to_quit = {'George': 9, 'John': 12, 'Mary': 1, 'Bobby': 14}

# Resource constraints
model.addConstr(john_hours * computer_competence['John'] + mary_hours * computer_competence['Mary'] >= 60)
model.addConstr(george_hours * computer_competence['George'] + mary_hours * computer_competence['Mary'] >= 73)
model.addConstr(john_hours * computer_competence['John'] + bobby_hours * computer_competence['Bobby'] >= 61)
model.addConstr(mary_hours * computer_competence['Mary'] + bobby_hours * computer_competence['Bobby'] >= 58)
model.addConstr(george_hours * computer_competence['George'] + bobby_hours * computer_competence['Bobby'] >= 65)
model.addConstr(george_hours * computer_competence['George'] + john_hours * computer_competence['John'] + mary_hours * computer_competence['Mary'] + bobby_hours * computer_competence['Bobby'] >= 65)

model.addConstr(john_hours * organization_score['John'] + bobby_hours * organization_score['Bobby'] >= 48)
model.addConstr(mary_hours * organization_score['Mary'] + bobby_hours * organization_score['Bobby'] >= 62)
model.addConstr(george_hours * organization_score['George'] + bobby_hours * organization_score['Bobby'] >= 29)
model.addConstr(john_hours * organization_score['John'] + mary_hours * organization_score['Mary'] >= 63)
model.addConstr(george_hours * organization_score['George'] + mary_hours * organization_score['Mary'] + bobby_hours * organization_score['Bobby'] >= 57)
model.addConstr(george_hours * organization_score['George'] + john_hours * organization_score['John'] + mary_hours * organization_score['Mary'] >= 57)
model.addConstr(george_hours * organization_score['George'] + mary_hours * organization_score['Mary'] + bobby_hours * organization_score['Bobby'] >= 51)
model.addConstr(george_hours * organization_score['George'] + john_hours * organization_score['John'] + mary_hours * organization_score['Mary'] >= 51)
model.addConstr(george_hours * organization_score['George'] + john_hours * organization_score['John'] + mary_hours * organization_score['Mary'] + bobby_hours * organization_score['Bobby'] >= 51)


model.addConstr(john_hours * productivity_rating['John'] + bobby_hours * productivity_rating['Bobby'] >= 42)
model.addConstr(mary_hours * productivity_rating['Mary'] + bobby_hours * productivity_rating['Bobby'] >= 42)
model.addConstr(george_hours * productivity_rating['George'] + john_hours * productivity_rating['John'] >= 25)
model.addConstr(george_hours * productivity_rating['George'] + mary_hours * productivity_rating['Mary'] >= 42)
model.addConstr(john_hours * productivity_rating['John'] + mary_hours * productivity_rating['Mary'] + bobby_hours * productivity_rating['Bobby'] >= 54)
model.addConstr(george_hours * productivity_rating['George'] + mary_hours * productivity_rating['Mary'] + bobby_hours * productivity_rating['Bobby'] >= 54)
model.addConstr(john_hours * productivity_rating['John'] + mary_hours * productivity_rating['Mary'] + bobby_hours * productivity_rating['Bobby'] >= 56)
model.addConstr(george_hours * productivity_rating['George'] + mary_hours * productivity_rating['Mary'] + bobby_hours * productivity_rating['Bobby'] >= 56)
model.addConstr(george_hours * productivity_rating['George'] + john_hours * productivity_rating['John'] + mary_hours * productivity_rating['Mary'] + bobby_hours * productivity_rating['Bobby'] >= 56)


model.addConstr(john_hours * likelihood_to_quit['John'] + mary_hours * likelihood_to_quit['Mary'] >= 44)
model.addConstr(george_hours * likelihood_to_quit['George'] + mary_hours * likelihood_to_quit['Mary'] >= 65)
model.addConstr(mary_hours * likelihood_to_quit['Mary'] + bobby_hours * likelihood_to_quit['Bobby'] >= 51)
model.addConstr(george_hours * likelihood_to_quit['George'] + mary_hours * likelihood_to_quit['Mary'] + bobby_hours * likelihood_to_quit['Bobby'] >= 40)
model.addConstr(john_hours * likelihood_to_quit['John'] + mary_hours * likelihood_to_quit['Mary'] + bobby_hours * likelihood_to_quit['Bobby'] >= 40)
model.addConstr(george_hours * likelihood_to_quit['George'] + mary_hours * likelihood_to_quit['Mary'] + bobby_hours * likelihood_to_quit['Bobby'] >= 70)
model.addConstr(john_hours * likelihood_to_quit['John'] + mary_hours * likelihood_to_quit['Mary'] + bobby_hours * likelihood_to_quit['Bobby'] >= 70)
model.addConstr(george_hours * likelihood_to_quit['George'] + john_hours * likelihood_to_quit['John'] + mary_hours * likelihood_to_quit['Mary'] + bobby_hours * likelihood_to_quit['Bobby'] >= 70)

model.addConstr(2 * john_hours - 4 * mary_hours >= 0)

# Upper bound constraints
model.addConstr(john_hours * computer_competence['John'] + bobby_hours * computer_competence['Bobby'] <= 137)
model.addConstr(john_hours * organization_score['John'] + bobby_hours * organization_score['Bobby'] <= 250)
model.addConstr(george_hours * productivity_rating['George'] + mary_hours * productivity_rating['Mary'] <= 173)
model.addConstr(george_hours * productivity_rating['George'] + bobby_hours * productivity_rating['Bobby'] <= 207)
model.addConstr(john_hours * productivity_rating['John'] + mary_hours * productivity_rating['Mary'] + bobby_hours * productivity_rating['Bobby'] <= 86)
model.addConstr(george_hours * productivity_rating['George'] + john_hours * productivity_rating['John'] + mary_hours * productivity_rating['Mary'] <= 177)
model.addConstr(george_hours * productivity_rating['George'] + john_hours * productivity_rating['John'] + bobby_hours * productivity_rating['Bobby'] <= 110)
model.addConstr(mary_hours * likelihood_to_quit['Mary'] + bobby_hours * likelihood_to_quit['Bobby'] <= 183)
model.addConstr(george_hours * likelihood_to_quit['George'] + john_hours * likelihood_to_quit['John'] + mary_hours * likelihood_to_quit['Mary'] <= 102)
model.addConstr(george_hours * likelihood_to_quit['George'] + john_hours * likelihood_to_quit['John'] + bobby_hours * likelihood_to_quit['Bobby'] <= 89)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('George Hours: %g' % george_hours.x)
    print('John Hours: %g' % john_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
    print('Bobby Hours: %g' % bobby_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)
