
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
hamburgers = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hamburgers")
pickles = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")
lemons = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lemons")

# Set objective function
model.setObjective(8.01 * hamburgers + 3.71 * pickles + 4.87 * lemons, GRB.MAXIMIZE)

# Add constraints
model.addConstr(12 * hamburgers + 7 * lemons >= 17, "c0")
model.addConstr(19 * pickles + 7 * lemons >= 18, "c1")
model.addConstr(12 * hamburgers + 19 * pickles >= 10, "c2")
model.addConstr(18 * hamburgers + 17 * pickles + 19 * lemons >= 68, "c3")
model.addConstr(12 * hamburgers + 19 * pickles <= 56, "c4")
model.addConstr(19 * pickles + 7 * lemons <= 53, "c5")
model.addConstr(12 * hamburgers + 19 * pickles + 7 * lemons <= 53, "c6")
model.addConstr(17 * pickles + 19 * lemons <= 110, "c7")
model.addConstr(18 * hamburgers + 19 * lemons <= 106, "c8")
model.addConstr(18 * hamburgers + 17 * pickles + 19 * lemons <= 71, "c9")
model.addConstr(18 * hamburgers + 17 * pickles + 19 * lemons <= 71, "c10")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('hamburgers:', hamburgers.x)
    print('pickles:', pickles.x)
    print('lemons:', lemons.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)

