
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Define variables
hamburgers = model.addVar(lb=0, name="hamburgers", vtype=GRB.CONTINUOUS)
pickles = model.addVar(lb=0, name="pickles", vtype=GRB.CONTINUOUS)
lemons = model.addVar(lb=0, name="lemons", vtype=GRB.CONTINUOUS)

# Define the objective function
model.setObjective(8.01*hamburgers + 3.71*pickles + 4.87*lemons, GRB.MAXIMIZE)

# Add constraints
model.addConstr(12*hamburgers + 7*lemons >= 17, name="umami_hamburgers_lemons_min")
model.addConstr(19*pickles + 7*lemons >= 18, name="umami_pickles_lemons_min")
model.addConstr(12*hamburgers + 19*pickles >= 10, name="umami_hamburgers_pickles_min")
model.addConstr(18*hamburgers + 17*pickles + 19*lemons >= 68, name="healthiness_all_min")
model.addConstr(12*hamburgers + 19*pickles <= 56, name="umami_hamburgers_pickles_max")
model.addConstr(19*pickles + 7*lemons <= 53, name="umami_pickles_lemons_max")
model.addConstr(12*hamburgers + 19*pickles + 7*lemons <= 53, name="umami_all_max")
model.addConstr(17*pickles + 19*lemons <= 110, name="healthiness_pickles_lemons_max")
model.addConstr(18*hamburgers + 19*lemons <= 106, name="healthiness_hamburgers_lemons_max")
model.addConstr(18*hamburgers + 17*pickles + 19*lemons <= 71, name="healthiness_all_max")

# Optimize model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hamburgers: {hamburgers.x}")
    print(f"Pickles: {pickles.x}")
    print(f"Lemons: {lemons.x}")
else:
    print("No optimal solution found.")
