
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    hamburgers = model.addVar(lb=0, name="hamburgers", vtype=gurobi.GRB.CONTINUOUS)
    pickles = model.addVar(lb=0, name="pickles", vtype=gurobi.GRB.CONTINUOUS)
    lemons = model.addVar(lb=0, name="lemons", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(8.01 * hamburgers + 3.71 * pickles + 4.87 * lemons, gurobi.GRB.MAXIMIZE)

    # Umami Index Constraints
    model.addConstr(12 * hamburgers + 7 * lemons >= 17, name="umami_h_l")
    model.addConstr(19 * pickles + 7 * lemons >= 18, name="umami_p_l")
    model.addConstr(12 * hamburgers + 19 * pickles >= 10, name="umami_h_p")
    model.addConstr(12 * hamburgers + 19 * pickles + 7 * lemons <= 53, name="umami_total")
    model.addConstr(19 * pickles + 7 * lemons <= 53, name="umami_p_l_max")
    model.addConstr(12 * hamburgers + 19 * pickles <= 56, name="umami_h_p_max")

    # Healthiness Rating Constraints
    model.addConstr(18 * hamburgers + 17 * pickles + 19 * lemons >= 68, name="health_total_min")
    model.addConstr(17 * pickles + 19 * lemons <= 110, name="health_p_l_max")
    model.addConstr(18 * hamburgers + 19 * lemons <= 106, name="health_h_l_max")
    model.addConstr(18 * hamburgers + 17 * pickles + 19 * lemons <= 71, name="health_total_max")

    # Optimize
    model.optimize()

    # Solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Hamburgers: {hamburgers.varValue}")
        print(f"Pickles: {pickles.varValue}")
        print(f"Lemons: {lemons.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
