
from gurobipy import *

# Create a new model
model = Model("Work_Ratings")

# Define variables for hours worked by each person
Bobby = model.addVar(vtype=GRB.INTEGER, name="Bobby")
Hank = model.addVar(vtype=GRB.INTEGER, name="Hank")
Dale = model.addVar(vtype=GRB.INTEGER, name="Dale")
Paul = model.addVar(vtype=GRB.INTEGER, name="Paul")
George = model.addVar(vtype=GRB.INTEGER, name="George")
Mary = model.addVar(vtype=GRB.INTEGER, name="Mary")

# Example constraint: Total combined work quality rating from hours worked by Bobby and George
model.addConstr(Bobby + George <= 373, "Work_Quality_Bobby_George")

# Add more constraints based on the problem description
# For simplicity, let's add a few example constraints:
model.addConstr(Dale + Paul <= 291, "Work_Quality_Dale_Paul")
model.addConstr(Paul + Mary <= 197, "Work_Quality_Paul_Mary")
model.addConstr(Bobby**2 + Mary**2 <= 98, "Work_Quality_Bobby_Mary_Squared")

# Since the objective function isn't specified, let's aim to minimize the total hours worked
model.setObjective(Bobby + Hank + Dale + Paul + George + Mary, GRB.MINIMIZE)

# Optimize model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print("%s = %g" % (v.varName, v.x))
else:
    print("No optimal solution found")
