
import gurobi as gp

model = gp.Model("optimization_problem")

B = model.addVar(lb=0, ub=None, name="Bobby", vtype=gp.GRB.INTEGER)
H = model.addVar(lb=0, ub=None, name="Hank", vtype=gp.GRB.INTEGER)
D = model.addVar(lb=0, ub=None, name="Dale", vtype=gp.GRB.INTEGER)
P = model.addVar(lb=0, ub=None, name="Paul", vtype=gp.GRB.INTEGER)
G = model.addVar(lb=0, ub=None, name="George", vtype=gp.GRB.INTEGER)
M = model.addVar(lb=0, ub=None, name="Mary", vtype=gp.GRB.INTEGER)

obj = 3*B**2 + B*H + 9*B*D + 4*B*P + 6*B*G + 4*B*M + 7*H**2 + 4*H*D + 6*H*P + D*P + 5*D*G + P**2 + 9*P*G + 2*P*M + 5*G**2 + G*M + 3*M**2 + 8*D + 3*P + 9*G + 8*M
model.setObjective(obj, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2*B + 6*H + 8*D + 12*P + 3*G + 3*M <= 461, name="work_quality")
model.addConstr(7*B + 16*H + 13*D + 8*P + 10*G + 10*M <= 187, name="computer_competence")
model.addConstr(13*B + 17*H + 7*D + 3*P + 15*G + 13*M <= 392, name="paperwork_competence")

model.addConstr(2*B + 6*H >= 60, name="work_quality_B_H_min")
model.addConstr(6*H + 8*D >= 53, name="work_quality_H_D_min")
model.addConstr(12*P + 3*G >= 42, name="work_quality_P_G_min")
model.addConstr(B**2 + P**2 >= 71, name="work_quality_B_P_min")
model.addConstr(H + G >= 56, name="work_quality_H_G_min")
model.addConstr(H + P + G >= 63, name="work_quality_H_P_G_min")
model.addConstr(B**2 + H**2 + D**2 >= 63, name="work_quality_B_H_D_min")
model.addConstr(H**2 + D**2 + M**2 >= 63, name="work_quality_H_D_M_min")
model.addConstr(B**2 + P**2 + G**2 >= 63, name="work_quality_B_P_G_min")
model.addConstr(B + D + P >= 63, name="work_quality_B_D_P_min")
model.addConstr(D + P + G >= 63, name="work_quality_D_P_G_min")
model.addConstr(D**2 + G**2 + M**2 >= 63, name="work_quality_D_G_M_min")
model.addConstr(B + D + G >= 63, name="work_quality_B_D_G_min")
model.addConstr(P**2 + G**2 + M**2 >= 63, name="work_quality_P_G_M_min")
model.addConstr(D**2 + P**2 + M**2 >= 63, name="work_quality_D_P_M_min")
model.addConstr(B**2 + D**2 + M**2 >= 63, name="work_quality_B_D_M_min")
model.addConstr(H + P + G >= 76, name="work_quality_H_P_G_min_76")
model.addConstr(B + H + D >= 76, name="work_quality_B_H_D_min_76")
model.addConstr(H + D + M >= 76, name="work_quality_H_D_M_min_76")
model.addConstr(B**2 + P**2 + G**2 >= 76, name="work_quality_B_P_G_min_76")
model.addConstr(B + D + P >= 76, name="work_quality_B_D_P_min_76")
model.addConstr(D + P + G >= 76, name="work_quality_D_P_G_min_76")
model.addConstr(D + G + M >= 76, name="work_quality_D_G_M_min_76")
model.addConstr(B**2 + D**2 + G**2 >= 76, name="work_quality_B_D_G_min_76")
model.addConstr(P**2 + G**2 + M**2 >= 76, name="work_quality_P_G_M_min_76")
model.addConstr(D + P + M >= 76, name="work_quality_D_P_M_min_76")
model.addConstr(B + D + M >= 76, name="work_quality_B_D_M_min_76")
model.addConstr(H + P + G >= 70, name="work_quality_H_P_G_min_70")
model.addConstr(B + H + D >= 70, name="work_quality_B_H_D_min_70")

model.optimize()

if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Bobby: ", B.varValue)
    print("Hank: ", H.varValue)
    print("Dale: ", D.varValue)
    print("Paul: ", P.varValue)
    print("George: ", G.varValue)
    print("Mary: ", M.varValue)
else:
    print("No optimal solution found")
